/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import de.matrixweb.smaller.maven.plugin.node.Logger;
import de.matrixweb.smaller.maven.plugin.node.NpmCache;
import de.matrixweb.smaller.maven.plugin.node.PackageInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.stringtemplate.v4.ST;

@Mojo(name="smaller-node-builder", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class SmallerNodeBuilderMojo
extends AbstractMojo {
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${basedir}")
    private File basedir;
    @Parameter(required=true)
    private String type;
    @Parameter(defaultValue="false")
    private boolean merging;
    @Parameter(required=true)
    private String name;
    @Parameter(required=true)
    private List<String> packages;
    @Parameter(alias="npm-only", defaultValue="false")
    private boolean npmOnly;
    @Parameter(defaultValue="${basedir}/target/generated-resources/npm-modules")
    private File target;
    private File tempInstall;
    @Parameter(alias="script-file")
    private File scriptFile;
    @Deprecated
    @Parameter(alias="skip-script")
    private Boolean skipScript;
    @Parameter(alias="use-runtime-script", defaultValue="false")
    private boolean useRuntimeScript;
    @Parameter
    private String script;
    @Parameter(defaultValue="false")
    private boolean forceUpdate;
    @Parameter(alias="delete-test-and-example", defaultValue="true")
    private boolean deleteTestAndExampleFolders;
    private NpmCache cache;

    @Deprecated
    public void setSkipScript(boolean skipScript) {
        this.useRuntimeScript = skipScript;
    }

    public final List<String> getPackages() {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        return this.packages;
    }

    public final void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public final void addPackage(String str) {
        this.getPackages().add(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.script == null && this.scriptFile == null) {
            throw new MojoFailureException("Either script or script-file is required");
        }
        this.cache = new NpmCache(this.basedir);
        try {
            this.tempInstall = File.createTempFile("smaller-node-builder-temp", ".dir");
            this.tempInstall.delete();
            this.tempInstall.mkdirs();
            try {
                for (String pkgSpec : this.packages) {
                    this.getLog().info((CharSequence)("Installing " + pkgSpec));
                    PackageInfo pkg = PackageInfo.createPackage(pkgSpec, new MavenLogger(), this.cache);
                    pkg.install(this.tempInstall, this.tempInstall, this.deleteTestAndExampleFolders);
                    FileUtils.copyDirectory((File)this.tempInstall, (File)new File(this.getPackageTarget(), "node_modules"));
                }
            }
            finally {
                FileUtils.deleteDirectory((File)this.tempInstall);
            }
            String javaCodeFolder = this.writeSources();
            this.updateProjectModel(javaCodeFolder);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to connect to npm registry", (Exception)e);
        }
    }

    private String writeSources() throws IOException {
        if (this.scriptFile != null) {
            if (!this.useRuntimeScript) {
                FileUtils.copyFile((File)this.scriptFile, (File)new File(this.getPackageTarget(), "index.js"));
            }
        } else {
            FileUtils.write((File)new File(this.getPackageTarget(), "index.js"), (CharSequence)new ST(IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("/index.js.tmpl"))).add("script", (Object)this.script).render());
        }
        File classbase = new File(this.basedir, "target/generated-sources/npm-processor");
        if (!this.npmOnly) {
            String[] nameParts = this.name.split("-", 2);
            String lowername = nameParts[0].toLowerCase();
            String uppername = nameParts[0].substring(0, 1).toUpperCase() + nameParts[0].substring(1).toLowerCase();
            String nameVersion = this.name;
            String uppertype = this.type.toUpperCase();
            File classtarget = new File(classbase, "de/matrixweb/smaller/" + lowername);
            String scriptName = "null";
            if (this.useRuntimeScript && this.scriptFile != null) {
                scriptName = this.scriptFile.getAbsolutePath();
                if (scriptName.startsWith(this.basedir.getAbsolutePath() + '/')) {
                    scriptName = scriptName.substring((this.basedir.getAbsolutePath() + '/').length());
                }
                if (scriptName.startsWith("src/main/resources/")) {
                    scriptName = scriptName.substring("src/main/resources/".length());
                }
                scriptName = '\"' + scriptName + '\"';
                this.getLog().info((CharSequence)("Using runtime script: " + scriptName));
            }
            classbase.mkdirs();
            FileUtils.write((File)new File(classtarget, uppername + "Processor.java"), (CharSequence)new ST(IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("/Processor.java.tmpl"))).add("lowername", (Object)lowername).add("uppername", (Object)uppername).add("name", (Object)nameParts[0]).add("nameVersion", (Object)nameVersion).add("version", (Object)nameParts[1]).add("uppertype", (Object)uppertype).add("merging", (Object)this.merging).add("scriptName", (Object)scriptName).render());
        }
        return classbase.getPath();
    }

    private void updateProjectModel(String javaCodeFolder) {
        if (!this.npmOnly) {
            this.project.addCompileSourceRoot(javaCodeFolder);
        }
        Resource resource = new Resource();
        resource.setDirectory(this.target.getAbsolutePath());
        this.project.addResource(resource);
    }

    private File getPackageTarget() {
        return new File(this.target, this.name);
    }

    private class MavenLogger
    implements Logger {
        private MavenLogger() {
        }

        @Override
        public void info(String message) {
            SmallerNodeBuilderMojo.this.getLog().info((CharSequence)message);
        }

        @Override
        public void debug(String message) {
            SmallerNodeBuilderMojo.this.getLog().debug((CharSequence)message);
        }
    }
}

