/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import de.matrixweb.smaller.maven.plugin.node.Descriptor;
import de.matrixweb.smaller.maven.plugin.node.Extractor;
import de.matrixweb.smaller.maven.plugin.node.Logger;
import de.matrixweb.smaller.maven.plugin.node.NpmCache;
import de.matrixweb.smaller.maven.plugin.node.PackageJson;
import de.matrixweb.smaller.maven.plugin.node.ParseException;
import de.matrixweb.smaller.maven.plugin.node.ParsedVersion;
import de.matrixweb.smaller.maven.plugin.node.Range;
import de.matrixweb.smaller.maven.plugin.node.SemanticVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

class PackageInfo {
    private static final ObjectMapper OM = new ObjectMapper();
    private final String name;
    private String version;
    private Descriptor descriptor;
    private final Logger log;
    private final NpmCache cache;
    private final File tempLocation;

    static PackageInfo createPackage(String input, Logger log, NpmCache cache) throws IOException {
        if (input.startsWith("git:") || input.startsWith("git+")) {
            return PackageInfo.fromGit(input, log, cache);
        }
        if (input.contains("@")) {
            return PackageInfo.fromNameVersion(input, log, cache);
        }
        return PackageInfo.fromUrl(input, log, cache);
    }

    private static PackageInfo fromGit(String input, Logger log, NpmCache cache) throws IOException {
        try {
            String uri = input;
            if (uri.startsWith("git+")) {
                uri = uri.substring(4);
            }
            String branch = "master";
            int idx = uri.indexOf("#");
            if (idx > -1) {
                branch = uri.substring(idx + 1);
                uri = uri.substring(0, idx);
            }
            File temp = File.createTempFile("smaller-node", ".dir");
            try {
                temp.delete();
                temp.mkdirs();
                CloneCommand clone = Git.cloneRepository();
                clone.setURI(uri).setDirectory(temp).setBranch(branch).setBare(false);
                clone.call().getRepository().close();
                log.debug("Cloned repository from " + input);
                for (String file : temp.list()) {
                    log.debug("  ... " + file);
                }
                return PackageInfo.createPackageFromTemp(temp, log, cache);
            }
            catch (IOException e) {
                FileUtils.deleteDirectory((File)temp);
                throw e;
            }
        }
        catch (GitAPIException e) {
            throw new IOException("Failed to clone git repository " + input, e);
        }
    }

    private static PackageInfo fromNameVersion(String input, Logger log, NpmCache cache) {
        int idx = input.indexOf(64);
        if (idx > -1) {
            return new PackageInfo(input.substring(0, idx), input.substring(idx + 1), null, log, cache);
        }
        return new PackageInfo(input, "", null, log, cache);
    }

    private static PackageInfo fromUrl(String input, Logger log, NpmCache cache) throws IOException {
        InputStream in = PackageInfo.get(cache, log, input, "Downloading .tar.gz");
        try {
            File temp = File.createTempFile("smaller-node", ".dir");
            try {
                temp.delete();
                temp.mkdirs();
                Extractor.uncompress(input, log, in, temp);
                File dir = temp;
                if (!new File(dir, "package.json").exists()) {
                    for (File sub : temp.listFiles()) {
                        if (!new File(sub, "package.json").exists()) continue;
                        dir = sub;
                        break;
                    }
                }
                if (!new File(dir, "package.json").exists()) {
                    throw new IOException("Failed to find package.json in tar.gz");
                }
                PackageInfo packageInfo = PackageInfo.createPackageFromTemp(dir, log, cache);
                return packageInfo;
            }
            catch (IOException e) {
                FileUtils.deleteDirectory((File)temp);
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static PackageInfo createPackageFromTemp(File temp, Logger log, NpmCache cache) throws IOException {
        PackageJson json = PackageInfo.getPackageJson(temp);
        return new PackageInfo(json.getName(), json.getVersion(), temp, log, cache);
    }

    private static InputStream get(NpmCache cache, Logger log, String url, String message) throws IOException {
        return PackageInfo.get(cache, false, log, url, message);
    }

    private static InputStream get(NpmCache cache, boolean forceUpdate, Logger log, String url, String message) throws IOException {
        InputStream in = cache.get(url, forceUpdate);
        if (in == null) {
            log.info(message + " " + url);
            Response response = Request.Get((String)url).execute();
            cache.put(url, response.returnContent().asStream());
            in = cache.get(url);
        }
        return in;
    }

    private static PackageJson getPackageJson(File dir) throws IOException {
        return (PackageJson)OM.readValue(new File(dir, "package.json"), PackageJson.class);
    }

    PackageInfo(String name, String version, File tempLocation, Logger log, NpmCache cache) {
        this.name = name;
        this.version = version;
        this.tempLocation = tempLocation;
        this.log = log;
        this.cache = cache;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Descriptor getDescriptor() throws IOException {
        if (this.descriptor == null) {
            InputStream in = PackageInfo.get(this.cache, this.log, "http://registry.npmjs.org/" + this.name, "Requesting");
            try {
                this.descriptor = (Descriptor)OM.readValue(in, Descriptor.class);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return this.descriptor;
    }

    private Map<String, String> getDependencies() throws IOException {
        if (this.tempLocation != null) {
            return PackageInfo.getPackageJson(this.tempLocation).getDependencies();
        }
        return this.getDescriptor().getVersions().get(this.version).getDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install(File root, File installDir, boolean deleteTestAndExampleFolders) throws IOException {
        if ("".equals(this.version)) {
            this.version = this.getDescriptor().getDistTags().getLatest();
        }
        File pkgDir = new File(installDir, this.name);
        try {
            this.installSources(pkgDir);
            if (deleteTestAndExampleFolders) {
                FileUtils.deleteDirectory((File)new File(pkgDir, "test"));
                FileUtils.deleteDirectory((File)new File(pkgDir, "tests"));
                FileUtils.deleteDirectory((File)new File(pkgDir, "example"));
                FileUtils.deleteDirectory((File)new File(pkgDir, "examples"));
            }
            this.installDependencies(root, this.getDependencies(), pkgDir, deleteTestAndExampleFolders);
        }
        finally {
            if (this.tempLocation != null) {
                FileUtils.deleteDirectory((File)this.tempLocation);
            }
        }
    }

    private void installSources(File pkgDir) throws IOException {
        if (this.tempLocation != null) {
            FileUtils.copyDirectory((File)this.tempLocation, (File)pkgDir);
        } else {
            Descriptor.Version versionDescriptor = this.getDescriptor().getVersions().get(this.version);
            if (versionDescriptor == null) {
                throw new IOException("Version " + this.version + " not found");
            }
            this.downloadAndExtract(versionDescriptor, pkgDir, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndExtract(Descriptor.Version versionDescriptor, File pkgDir, boolean retry, boolean forceUpdate) throws IOException {
        try {
            InputStream in = this.getTarball(versionDescriptor, forceUpdate);
            try {
                Extractor.uncompress(this.name, this.version, this.log, in, pkgDir, forceUpdate);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        catch (IOException e) {
            if (retry) {
                this.log.info("Retry with redownloading and extracting");
                this.downloadAndExtract(versionDescriptor, pkgDir, false, true);
            }
            throw e;
        }
    }

    private InputStream getTarball(Descriptor.Version version, boolean forceUpdate) throws IOException {
        File local = new File(System.getProperty("user.home"), ".npm/" + this.name + "/" + this.version + "/package.tgz");
        this.log.debug("Check local .npm for " + local);
        if (local.exists()) {
            return new FileInputStream(local);
        }
        return PackageInfo.get(this.cache, this.log, version.getDist().getTarball(), "Downloading");
    }

    private void installDependencies(File root, Map<String, String> dependencies, File pkgDir, boolean deleteTestAndExampleFolders) throws IOException {
        for (Map.Entry<String, String> dependency : dependencies.entrySet()) {
            String pkgName = dependency.getKey();
            String requiredVersion = dependency.getValue();
            this.log.debug("Looking for " + pkgName + '@' + requiredVersion + " in parent folders of " + pkgDir);
            String foundVersion = this.findInstalledVersion(root, pkgDir, pkgName);
            try {
                PackageInfo depPkg;
                if (foundVersion != null && this.satisfies(requiredVersion, foundVersion)) continue;
                try {
                    depPkg = new PackageInfo(pkgName, "", null, this.log, this.cache);
                    depPkg.setVersion(SemanticVersion.getBestMatch(depPkg.getDescriptor().getVersions().keySet(), requiredVersion));
                }
                catch (ParseException e) {
                    depPkg = PackageInfo.createPackage(requiredVersion, this.log, this.cache);
                }
                depPkg.install(root, new File(pkgDir, "node_modules"), deleteTestAndExampleFolders);
            }
            catch (IOException e) {
                throw new IOException("Failed to install dependecy for " + pkgName + " version " + requiredVersion, e);
            }
            catch (ParseException e) {
                throw new IOException("Failed to find dependency " + pkgName + " version " + requiredVersion, e);
            }
        }
    }

    private boolean satisfies(String requiredVersion, String foundVersion) {
        Range range = new Range(requiredVersion);
        return range.satisfies(ParsedVersion.parse(foundVersion));
    }

    private String findInstalledVersion(File root, File dir, String pkgName) throws IOException {
        String version = null;
        File nodeModulesDir = new File(dir, "node_modules");
        File pkgDir = new File(nodeModulesDir, pkgName);
        if (pkgDir.exists()) {
            this.log.debug("  searching " + pkgDir + "...");
            PackageJson json = PackageInfo.getPackageJson(pkgDir);
            version = json.getVersion();
            this.log.debug("  found version " + version);
        } else if (!dir.getParentFile().equals(root)) {
            version = this.findInstalledVersion(root, dir.getParentFile(), pkgName);
        }
        return version;
    }

    static {
        OM.setDeserializationConfig(OM.getDeserializationConfig().without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES}));
    }
}

