/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.maven.plugin.node;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

class NpmCache {
    private final File base;

    NpmCache(File base) {
        this.base = new File(base, "target/npm-cache");
        this.base.mkdirs();
    }

    private String mangle(String in) {
        return in.replace('/', '-').replace(':', '-');
    }

    private File entry(String url) {
        return new File(this.base, this.mangle(url));
    }

    InputStream get(String url) throws IOException {
        return this.get(url, false);
    }

    InputStream get(String url, boolean forceUpdate) throws IOException {
        File entry = this.entry(url);
        if (entry.exists()) {
            if (forceUpdate) {
                entry.delete();
            } else {
                return new FileInputStream(entry);
            }
        }
        return null;
    }

    void put(String url, InputStream in) throws IOException {
        File entry = this.entry(url);
        FileUtils.copyInputStreamToFile((InputStream)in, (File)entry);
    }
}

