/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.maven;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.maven.SmallerClient;
import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.config.ConfigFile;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.VFSResourceResolver;
import de.matrixweb.smaller.resource.impl.JavaEEProcessorFactory;
import de.matrixweb.vfs.Logger;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.wrapped.JavaFile;
import de.matrixweb.vfs.wrapped.WrappedSystem;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class SmallerStandaloneMojo
extends AbstractMojo {
    private String host;
    private String port;
    private final String proxyhost;
    private final String proxyport;
    private File target;
    private File configFile;

    public SmallerStandaloneMojo() {
        this.proxyhost = null;
        this.proxyport = null;
    }

    public void setTarget(String target) {
        this.target = new File(target);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Write result to " + this.target));
        SmallerClient client = new SmallerClient(this.getLog(), this.host, this.port, this.proxyhost, this.proxyport, this.target, this.configFile){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void executeSmaller(File base, List<String> includedFiles, File target, String host, String port, String proxyhost, String proxyport, ConfigFile configFile) throws ExecutionException {
                JavaEEProcessorFactory processorFactory = new JavaEEProcessorFactory();
                try {
                    VFS vfs = new VFS(new Logger(){

                        public void debug(String message) {
                            SmallerStandaloneMojo.this.getLog().debug((CharSequence)message);
                        }

                        public void info(String messsage) {
                            SmallerStandaloneMojo.this.getLog().info((CharSequence)messsage);
                        }

                        public void error(String message, Exception e) {
                            SmallerStandaloneMojo.this.getLog().error((CharSequence)message, (Throwable)e);
                        }
                    });
                    try {
                        SmallerStandaloneMojo.this.getLog().info((CharSequence)("MVN: Adding " + base + " to VFS"));
                        vfs.mount(vfs.find("/"), (WrappedSystem)new JavaFile(base));
                        VFSResourceResolver resolver = new VFSResourceResolver(vfs);
                        Manifest manifest = Manifest.fromConfigFile((ConfigFile)configFile);
                        Pipeline pipeline = new Pipeline((ProcessorFactory)processorFactory);
                        pipeline.execute(Version.getCurrentVersion(), vfs, (ResourceResolver)resolver, manifest, target);
                    }
                    finally {
                        vfs.dispose();
                    }
                }
                catch (IOException e) {
                    throw new ExecutionException("Embedded smaller failed", (Throwable)e);
                }
                finally {
                    processorFactory.dispose();
                }
            }
        };
        client.execute();
    }
}

