/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.maven;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.maven.SmallerClient;
import de.matrixweb.smaller.clients.maven.Task;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.smaller.resource.impl.JavaEEProcessorFactory;
import de.matrixweb.smaller.resource.vfs.VFS;
import de.matrixweb.smaller.resource.vfs.VFSResourceResolver;
import de.matrixweb.smaller.resource.vfs.wrapped.JavaFile;
import de.matrixweb.smaller.resource.vfs.wrapped.WrappedSystem;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;

public class SmallerStandaloneMojo
extends AbstractMojo {
    private String host;
    private String port;
    private final String proxyhost;
    private final String proxyport;
    private File target;
    private String processor;
    private String in;
    private String out;
    private String options;
    private FileSet files;
    private List<Task> tasks;

    public SmallerStandaloneMojo() {
        this.proxyhost = null;
        this.proxyport = null;
    }

    public void setTarget(String target) {
        this.target = new File(target);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Write result to " + this.target));
        SmallerClient client = new SmallerClient(this.getLog(), this.host, this.port, this.proxyhost, this.proxyport, this.target, this.processor, this.in, this.out, this.options, this.files, this.tasks){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void executeSmaller(File base, String[] includedFiles, File target, String host, String port, String proxyhost, String proxyport, de.matrixweb.smaller.common.Task[] tasks) throws ExecutionException {
                JavaEEProcessorFactory processorFactory = new JavaEEProcessorFactory();
                try {
                    VFS vfs = new VFS();
                    try {
                        vfs.mount(vfs.find("/"), (WrappedSystem)new JavaFile(base));
                        Result result = new Pipeline((ProcessorFactory)processorFactory).execute(Version.getCurrentVersion(), vfs, (ResourceResolver)new VFSResourceResolver(vfs), tasks[0]);
                        if (!Task.GlobalOptions.isOutOnly((de.matrixweb.smaller.common.Task)tasks[0])) {
                            vfs.exportFS(target);
                        }
                        for (String out : tasks[0].getOut()) {
                            for (Type type : Type.values()) {
                                if (!type.isOfType(FilenameUtils.getExtension((String)out))) continue;
                                FileUtils.writeStringToFile((File)new File(target, out), (String)result.get(type).getContents());
                            }
                        }
                    }
                    finally {
                        vfs.dispose();
                    }
                }
                catch (IOException e) {
                    throw new ExecutionException("Embedded smaller failed", (Throwable)e);
                }
                finally {
                    processorFactory.dispose();
                }
            }
        };
        client.execute();
    }
}

