/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.maven;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.common.Logger;
import de.matrixweb.smaller.clients.common.Util;
import de.matrixweb.smaller.config.ConfigFile;
import de.matrixweb.smaller.config.Environment;
import de.matrixweb.smaller.config.Processor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallerClient {
    private final Log log;
    private final String host;
    private final String port;
    private final String proxyhost;
    private final String proxyport;
    private final File target;
    private final File configFilePath;

    public SmallerClient(Log log, String host, String port, String proxyhost, String proxyport, File target, File configFilePath) {
        this.log = log;
        this.host = host;
        this.port = port;
        this.proxyhost = proxyhost;
        this.proxyport = proxyport;
        this.target = target;
        this.configFilePath = configFilePath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File temp = File.createTempFile("smaller-maven", ".dir");
            try {
                temp.delete();
                temp.mkdirs();
                this.log.info((CharSequence)("Reading config-file: " + this.configFilePath));
                ConfigFile configFile = ConfigFile.read((File)this.configFilePath);
                ArrayList<String> includedFiles = new ArrayList<String>();
                for (String envName : configFile.getBuildServer().getEnvironments()) {
                    Environment env = (Environment)configFile.getEnvironments().get(envName);
                    for (String dir : env.getFiles().getFolder()) {
                        String[] included;
                        this.copyFirstInputFile(env, dir, temp);
                        File base = new File(dir);
                        if (!base.isAbsolute()) {
                            base = new File(this.configFilePath.getParentFile(), base.getPath());
                        }
                        for (String include : included = this.scanIncludedFiles(base.getAbsolutePath(), env.getFiles().getIncludes(), env.getFiles().getExcludes())) {
                            FileUtils.copyFile((File)new File(base, include), (File)new File(temp, include));
                            includedFiles.add(include);
                        }
                    }
                }
                this.executeSmaller(temp, includedFiles, this.target, this.host, this.port, this.proxyhost, this.proxyport, configFile);
            }
            catch (ExecutionException e) {
                this.log.error((CharSequence)Util.formatException((Exception)((Object)e)));
                throw new MojoExecutionException("Failed execute smaller", (Exception)((Object)e));
            }
            finally {
                FileUtils.deleteDirectory((File)temp);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read config file from " + this.configFilePath, (Exception)e);
        }
    }

    private void copyFirstInputFile(Environment env, String dir, File temp) throws IOException {
        String input = ((Processor)env.getProcessors().get(env.getPipeline()[0])).getSrc();
        if (input != null) {
            File inputFile = new File(dir, input);
            if (!inputFile.isAbsolute()) {
                inputFile = new File(this.configFilePath.getParentFile(), inputFile.getPath());
            }
            if (inputFile.exists()) {
                FileUtils.copyFile((File)inputFile, (File)new File(temp, input));
            }
        }
    }

    private String[] scanIncludedFiles(String dir, String[] includes, String[] excludes) {
        FileSet set = new FileSet();
        this.log.debug((CharSequence)("Scanning " + dir));
        set.setDirectory(dir);
        if (includes != null) {
            for (String include : includes) {
                this.log.debug((CharSequence)("  including " + include));
                set.addInclude(include);
            }
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                this.log.debug((CharSequence)("  excluding " + exclude));
                set.addExclude(exclude);
            }
        }
        return new FileSetManager().getIncludedFiles(set);
    }

    protected void executeSmaller(File base, List<String> includedFiles, File target, String host, String port, String proxyhost, String proxyport, ConfigFile configFile) throws ExecutionException {
        Util util = new Util((Logger)new MavenLogger());
        util.unzip(target, util.send(host, port, proxyhost, proxyport, util.zip(base, includedFiles, configFile)));
    }

    private class MavenLogger
    implements Logger {
        private MavenLogger() {
        }

        public void debug(String message) {
            SmallerClient.this.log.debug((CharSequence)message);
        }
    }
}

