/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.maven;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.common.Logger;
import de.matrixweb.smaller.clients.common.Util;
import de.matrixweb.smaller.clients.maven.Task;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallerClient {
    private final Log log;
    private final String host;
    private final String port;
    private final String proxyhost;
    private final String proxyport;
    private final File target;
    private final String processor;
    private final String in;
    private final String out;
    private final String options;
    private final FileSet files;
    private List<Task> tasks;

    public SmallerClient(Log log, String host, String port, String proxyhost, String proxyport, File target, String processor, String in, String out, String options, FileSet files, List<Task> tasks) {
        this.log = log;
        this.host = host;
        this.port = port;
        this.proxyhost = proxyhost;
        this.proxyport = proxyport;
        this.target = target;
        this.processor = processor;
        this.in = in;
        this.out = out;
        this.options = options;
        this.files = files;
        this.tasks = tasks;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File base = new File(this.files.getDirectory());
            FileSetManager fileSetManager = new FileSetManager();
            String[] includedFiles = fileSetManager.getIncludedFiles(this.files);
            if (this.processor != null && this.in != null && this.out != null) {
                Task direct = new Task();
                direct.setProcessor(this.processor);
                direct.setIn(this.in);
                direct.setOut(this.out);
                direct.setOptions(this.options);
                if (this.tasks == null) {
                    this.tasks = new ArrayList<Task>();
                }
                this.tasks.add(direct);
            }
            this.executeSmaller(base, includedFiles, this.target, this.host, this.port, this.proxyhost, this.proxyport, this.convertTasks());
        }
        catch (ExecutionException e) {
            this.log.error((CharSequence)Util.formatException((Exception)((Object)e)));
            throw new MojoExecutionException("Failed execute smaller", (Exception)((Object)e));
        }
    }

    protected void executeSmaller(File base, String[] includedFiles, File target, String host, String port, String proxyhost, String proxyport, de.matrixweb.smaller.common.Task[] tasks) throws ExecutionException {
        Util util = new Util((Logger)new MavenLogger());
        util.unzip(target, util.send(host, port, proxyhost, proxyport, util.zip(base, includedFiles, tasks)));
    }

    private de.matrixweb.smaller.common.Task[] convertTasks() {
        ArrayList<de.matrixweb.smaller.common.Task> list = new ArrayList<de.matrixweb.smaller.common.Task>();
        for (Task task : this.tasks) {
            list.add(new de.matrixweb.smaller.common.Task(task.getProcessor(), task.getIn(), task.getOut(), task.getOptions()));
        }
        return list.toArray(new de.matrixweb.smaller.common.Task[list.size()]);
    }

    private class MavenLogger
    implements Logger {
        private MavenLogger() {
        }

        public void debug(String message) {
            SmallerClient.this.log.debug((CharSequence)message);
        }
    }
}

