/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Processor {
    private String src;
    private String dest;
    private Map<String, Object> options;

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public Map<String, Option> getOptions() {
        HashMap<String, Option> map = new HashMap<String, Option>();
        if (this.options != null) {
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                map.put(entry.getKey(), new Option(entry.getValue()));
            }
        }
        return map;
    }

    public Map<String, Object> getPlainOptions() {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public static class Option {
        private Object value;

        public Option(String value) {
            this.value = value;
        }

        public Option(Boolean value) {
            this.value = value;
        }

        public Option(Integer value) {
            this.value = value;
        }

        public Option(Double value) {
            this.value = value;
        }

        public Option(Map<String, Object> value) {
            this.value = value;
        }

        private Option(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @JsonIgnore
        public String getString() {
            return this.value != null ? this.value.toString() : null;
        }

        @JsonIgnore
        public Boolean getBoolean() {
            return this.value != null ? Boolean.valueOf(this.value.toString()) : null;
        }

        @JsonIgnore
        public Integer getInteger() {
            return this.value != null ? Integer.valueOf(this.value.toString()) : null;
        }

        @JsonIgnore
        public Double getDouble() {
            return this.value != null ? Double.valueOf(this.value.toString()) : null;
        }

        @JsonIgnore
        public Map<String, Object> getMap() {
            return (Map)this.value;
        }
    }
}

