/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.smaller.config.BuildServer;
import de.matrixweb.smaller.config.DevServer;
import de.matrixweb.smaller.config.Environment;
import de.matrixweb.smaller.config.Processor;
import de.matrixweb.smaller.config.TypeHint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigFile {
    @JsonProperty(value="build-server")
    private BuildServer buildServer;
    @JsonProperty(value="dev-server")
    private DevServer devServer;
    @TypeHint(type=Environment.class)
    private Map<String, Environment> environments;

    public static ConfigFile read(File file) throws IOException {
        return ConfigFile.read(file.toURI().toURL());
    }

    public static ConfigFile read(URL url) throws IOException {
        ConfigFile configFile;
        try {
            configFile = new ObjectMapper().readValue(url, ConfigFile.class);
        }
        catch (JsonProcessingException e) {
            configFile = ConfigFile.readYaml(url);
        }
        for (Environment env : configFile.getEnvironments().values()) {
            env.setConfigFile(configFile);
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigFile readYaml(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            class OptionConstructor
            extends Constructor {
                public OptionConstructor() {
                    this.yamlConstructors.put(new Tag("!option"), new 1OptionConstructor.ConstructOption());
                }

                class 1OptionConstructor.ConstructOption
                extends AbstractConstruct {
                    1OptionConstructor.ConstructOption() {
                    }

                    @Override
                    public Object construct(Node node) {
                        switch (node.getNodeId()) {
                            case sequence: {
                                return this.constructSequence((SequenceNode)node);
                            }
                            case mapping: {
                                return this.constructMapping((MappingNode)node);
                            }
                            case scalar: {
                                return this.constructScalar((ScalarNode)node);
                            }
                        }
                        return OptionConstructor.super.constructObject(node);
                    }
                }
            }
            Object object = new Yaml(new OptionConstructor()).load(in);
            if (object instanceof ConfigFile) {
                ConfigFile configFile = (ConfigFile)object;
                return configFile;
            }
            class Mapper {
                Mapper() {
                }

                <T> T map(Class<T> clazz, Map<String, Object> map) {
                    try {
                        T object = clazz.newInstance();
                        for (Field field : clazz.getDeclaredFields()) {
                            String name = this.getMappedName(field);
                            if (!map.containsKey(name)) continue;
                            Map<String, Object> value = map.get(name);
                            if (value instanceof Map) {
                                value = Map.class.isAssignableFrom(field.getType()) ? this.mapToMap(field, value) : this.map(field.getType(), value);
                            }
                            boolean accessible = field.isAccessible();
                            try {
                                field.setAccessible(true);
                                value = this.convertCollectionToArray(field.getType(), value);
                                field.set(object, value);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            finally {
                                field.setAccessible(accessible);
                            }
                        }
                        return object;
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }

                private String getMappedName(Field field) {
                    String name = field.getName();
                    if (field.isAnnotationPresent(JsonProperty.class)) {
                        name = field.getAnnotation(JsonProperty.class).value();
                    }
                    return name;
                }

                private Map<String, Object> mapToMap(Field field, Map<String, Object> value) {
                    Map<String, Object> result = value;
                    if (field.isAnnotationPresent(TypeHint.class)) {
                        Class<?> type = field.getAnnotation(TypeHint.class).type();
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        for (Map.Entry<String, Object> entry : result.entrySet()) {
                            Object entryValue = entry.getValue();
                            if (entryValue instanceof Map) {
                                valueMap.put(entry.getKey(), this.map(type, (Map)entry.getValue()));
                                continue;
                            }
                            valueMap.put(entry.getKey(), this.convertCollectionToArray(type, entryValue));
                        }
                        result = valueMap;
                    }
                    return result;
                }

                private Object convertCollectionToArray(Class<?> type, Object value) {
                    Object[] result = value;
                    if (type.isArray() && result instanceof Collection) {
                        result = ((Collection)result).toArray((Object[])Array.newInstance(type.getComponentType(), 0));
                    }
                    return result;
                }
            }
            ConfigFile configFile = new Mapper().map(ConfigFile.class, (Map)object);
            return configFile;
        }
        finally {
            in.close();
        }
    }

    public String dumpYaml() {
        class OptionRepresenter
        extends Representer {
            OptionRepresenter() {
                this.representers.put(Processor.Option.class, new 1OptionRepresenter.RepresentOption());
            }

            class 1OptionRepresenter.RepresentOption
            implements Represent {
                1OptionRepresenter.RepresentOption() {
                }

                @Override
                public Node representData(Object data) {
                    Object value = ((Processor.Option)data).getValue();
                    if (value instanceof Iterable) {
                        return this.representSequence(new Tag("!option"), (Iterable)value, true);
                    }
                    if (value instanceof Map) {
                        return this.representMapping(new Tag("!option"), (Map)value, true);
                    }
                    if (value instanceof String) {
                        return this.representScalar(new Tag("!option"), (String)value);
                    }
                    return OptionRepresenter.super.representData(value);
                }
            }
        }
        return new Yaml(new OptionRepresenter(), new DumperOptions()).dump(this);
    }

    public BuildServer getBuildServer() {
        if (this.buildServer == null) {
            this.buildServer = new BuildServer();
        }
        return this.buildServer;
    }

    public void setBuildServer(BuildServer buildServer) {
        this.buildServer = buildServer;
    }

    public DevServer getDevServer() {
        if (this.devServer == null) {
            this.devServer = new DevServer();
        }
        return this.devServer;
    }

    public void setDevServer(DevServer devServer) {
        this.devServer = devServer;
    }

    public Map<String, Environment> getEnvironments() {
        if (this.environments == null) {
            this.environments = new HashMap<String, Environment>();
            this.environments.put("first", new Environment());
        }
        return this.environments;
    }

    public void setEnvironments(Map<String, Environment> environments) {
        this.environments = environments;
    }
}

