/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.common.Logger;
import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.ProcessDescription;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.common.Zip;
import de.matrixweb.smaller.config.ConfigFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private final Logger logger;
    private boolean debug = false;

    public Util(Logger logger) {
        this(logger, false);
    }

    public Util(Logger logger, boolean debug) {
        this.logger = logger;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] zip(File base, List<String> includedFiles, ConfigFile configFile) throws ExecutionException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            File temp = File.createTempFile("maven-smaller", ".dir");
            try {
                File target;
                temp.delete();
                temp.mkdirs();
                Manifest manifest = this.writeManifest(temp, configFile);
                for (String includedFile : includedFiles) {
                    this.logger.debug("Adding " + includedFile + " to zip");
                    target = new File(temp, includedFile);
                    target.getParentFile().mkdirs();
                    FileUtils.copyFile(new File(base, includedFile), target);
                }
                for (ProcessDescription pd : manifest.getProcessDescriptions()) {
                    target = new File(temp, pd.getInputFile());
                    target.getParentFile().mkdirs();
                    FileUtils.copyFile(new File(base, pd.getInputFile()), target);
                }
                Zip.zip(baos, temp);
            }
            finally {
                if (!this.debug) {
                    FileUtils.deleteDirectory(temp);
                } else {
                    this.logger.debug("Path to input files: " + temp);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to create zip file for upload", e);
        }
    }

    private Manifest writeManifest(File temp, ConfigFile configFile) throws ExecutionException {
        try {
            Manifest manifest = Manifest.fromConfigFile(configFile);
            File metaInf = new File(temp, "META-INF");
            metaInf.mkdirs();
            new ObjectMapper().writeValue(new File(metaInf, "smaller.json"), (Object)manifest);
            return manifest;
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to write manifest", e);
        }
    }

    @Deprecated
    public Manifest convertConfigFileToManifest(ConfigFile configFile) {
        return Manifest.fromConfigFile(configFile);
    }

    public byte[] send(String host, String port, byte[] bytes) throws ExecutionException {
        return this.send(host, port, null, null, bytes);
    }

    public byte[] send(String host, String port, String proxyhost, String proxyport, byte[] bytes) throws ExecutionException {
        try {
            Request request = Request.Post("http://" + host + ":" + port).socketTimeout(0).connectTimeout(0);
            if (proxyhost != null && proxyport != null) {
                request.viaProxy(new HttpHost(proxyhost, Integer.valueOf(proxyport)));
            }
            HttpResponse response = request.addHeader("X-Smaller-Spec-Version", Version.getCurrentVersion().toString()).bodyByteArray(bytes).execute().returnResponse();
            return this.handleResponse(response);
        }
        catch (Exception e) {
            if (e instanceof SmallerException) {
                throw (SmallerException)e;
            }
            throw new ExecutionException("Failed to send zip file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] handleResponse(HttpResponse response) throws IOException, ExecutionException {
        InputStream in = response.getEntity().getContent();
        try {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ExecutionException(IOUtils.toString(in));
            }
            if (this.getHeader(response, "X-Smaller-Status").equals("ERROR")) {
                throw new SmallerException(this.getHeader(response, "X-Smaller-Message").replace("#@@#", "\n"));
            }
            byte[] byArray = IOUtils.toByteArray(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private String getHeader(HttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header != null ? header.getValue() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(File target, byte[] bytes) throws ExecutionException {
        try {
            File temp = File.createTempFile("smaller", ".zip");
            temp.delete();
            FileOutputStream fos = new FileOutputStream(temp);
            try {
                IOUtils.write(bytes, (OutputStream)fos);
                target.mkdirs();
                Zip.unzip(temp, target);
            }
            finally {
                IOUtils.closeQuietly(fos);
                if (!this.debug) {
                    temp.delete();
                } else {
                    this.logger.debug("Path to output files: " + temp);
                }
            }
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to handle smaller response", e);
        }
    }

    public static String formatException(Exception e) {
        StringBuilder sb = new StringBuilder();
        for (Throwable t = e; t != null; t = t.getCause()) {
            sb.append(t.getMessage()).append("\n");
        }
        return sb.toString();
    }
}

