/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.servlet;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

public class ResourceScanner {
    private final ServletContext servletContext;
    private final String[] includes;
    private final String[] excludes;

    public ResourceScanner(ServletContext servletContext, String[] includes, String[] excludes) {
        this.servletContext = servletContext;
        this.includes = includes;
        this.excludes = excludes;
    }

    public Set<String> getResources() {
        HashSet<String> resources = new HashSet<String>();
        String[] stringArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            resources.addAll(this.findCandidates("/", include));
            ++n2;
        }
        stringArray = this.excludes;
        n = this.excludes.length;
        n2 = 0;
        while (n2 < n) {
            String exclude;
            for (String match : this.filterRecursive(resources, "/", exclude, !(exclude = stringArray[n2]).startsWith("**"))) {
                resources.remove(match);
            }
            ++n2;
        }
        resources.remove(null);
        return resources;
    }

    private Set<String> findCandidates(String base, String include) {
        HashSet<String> candidates = new HashSet<String>();
        int starstar = include.indexOf("**");
        if (starstar > -1) {
            candidates.addAll(this.filterRecursive(base, include, starstar, starstar > 0));
        } else {
            int star = include.indexOf(42);
            if (star > -1) {
                candidates.addAll(this.filterRecursive(base, include, star, true));
            } else {
                candidates.add(this.findDirect(base, include));
            }
        }
        return candidates;
    }

    private Set<String> findRecursive(String base) {
        HashSet<String> matches = new HashSet<String>();
        for (String match : this.servletContext.getResourcePaths(base)) {
            if (match.endsWith("/")) {
                matches.addAll(this.findRecursive(match));
                continue;
            }
            matches.add(match);
        }
        return matches;
    }

    private Set<String> filterRecursive(String base, String include, int index, boolean prefixPatternWithBase) {
        return this.filterRecursive(this.findRecursive(String.valueOf(base) + include.substring(0, index)), base, include, prefixPatternWithBase);
    }

    private Set<String> filterRecursive(Set<String> matches, String base, String include, boolean prefixPatternWithBase) {
        HashSet<String> result = new HashSet<String>();
        String pattern = include.replace(".", "\\.").replace("**", "#starstar#").replace("*", "[^/]+").replace("#starstar#", ".*");
        if (prefixPatternWithBase) {
            pattern = String.valueOf(base) + pattern;
        }
        Pattern expr = Pattern.compile(pattern);
        for (String match : matches) {
            if (match == null || !expr.matcher(match).matches()) continue;
            result.add(match);
        }
        return result;
    }

    private String findDirect(String base, String include) {
        String parent = include.substring(0, include.lastIndexOf(47));
        for (String match : this.servletContext.getResourcePaths(String.valueOf(base) + parent)) {
            if (!match.equals(String.valueOf(base) + include)) continue;
            return match;
        }
        return null;
    }
}

