/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.servlet;

import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.impl.JavaEEProcessorFactory;
import de.matrixweb.smaller.servlet.ResourceScanner;
import de.matrixweb.smaller.servlet.ServletContextResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class EmbeddedSmaller {
    private FilterConfig filterConfig;
    private ServletConfig servletConfig;
    private Result result;

    public EmbeddedSmaller(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public EmbeddedSmaller(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public void init() throws ServletException {
        if (!this.isDevelopment() && !this.isLazy()) {
            this.process();
        }
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean exists;
        boolean bl = exists = this.exists(request) && !this.isForce();
        if (!exists && (this.isDevelopment() || this.requireLazyRun())) {
            this.process();
        }
        String contentType = this.getContentType(request);
        response.setContentType(contentType);
        PrintWriter writer = response.getWriter();
        writer.print(this.getContent(request, exists, contentType));
        writer.close();
    }

    private boolean requireLazyRun() {
        return this.isLazy() && this.result == null;
    }

    private boolean exists(HttpServletRequest request) throws MalformedURLException {
        return this.getServletContext().getResource(request.getRequestURI()) != null;
    }

    private String getContentType(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            if (request.getRequestURI().endsWith("js")) {
                contentType = "text/javascript";
            } else if (request.getRequestURI().endsWith("css")) {
                contentType = "text/css";
            }
        }
        return contentType;
    }

    private String getContent(HttpServletRequest request, boolean exists, String contentType) throws IOException {
        if (exists) {
            InputStream in = this.getServletContext().getResourceAsStream(request.getRequestURI());
            try {
                String string = IOUtils.toString((InputStream)in);
                return string;
            }
            finally {
                in.close();
            }
        }
        return this.result.get(contentType).getContents();
    }

    private String getInitParameter(String name) {
        if (this.servletConfig != null) {
            return this.servletConfig.getInitParameter(name);
        }
        return this.filterConfig.getInitParameter(name);
    }

    private ServletContext getServletContext() {
        if (this.servletConfig != null) {
            return this.servletConfig.getServletContext();
        }
        return this.filterConfig.getServletContext();
    }

    private boolean isForce() {
        return "true".equals(this.getInitParameter("force"));
    }

    private boolean isDevelopment() {
        return "development".equals(this.getInitParameter("mode"));
    }

    private boolean isLazy() {
        return "lazy".equals(this.getInitParameter("mode"));
    }

    private void process() throws ServletException {
        String processors = this.getInitParameter("processors");
        if (processors == null) {
            throw new ServletException("init-param 'processors' must be configured");
        }
        String includes = this.getInitParameter("includes");
        if (StringUtils.isBlank((CharSequence)includes)) {
            throw new ServletException("init-param 'includes' must be configured");
        }
        String excludes = this.getInitParameter("excludes");
        Set<String> resources = new ResourceScanner(this.getServletContext(), includes.split("[, ]"), excludes != null ? excludes.split("[, ]") : new String[]{}).getResources();
        String options = this.getInitParameter("options");
        Task task = new Task();
        task.setProcessor(processors);
        task.setIn(resources.toArray(new String[resources.size()]));
        task.setOptionsDefinition(options);
        this.result = new Pipeline((ProcessorFactory)new JavaEEProcessorFactory()).execute((ResourceResolver)new ServletContextResourceResolver(this.getServletContext()), task);
    }
}

