/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.servlet;

import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ServletContextResourceResolver
implements ResourceResolver {
    private final ServletContext context;
    private final String base;

    public ServletContextResourceResolver(ServletContext context) {
        this(context, "/");
    }

    public ServletContextResourceResolver(ServletContext context, String base) {
        this.context = context;
        this.base = base;
    }

    public Resource resolve(String path) {
        if (path == null) {
            return null;
        }
        String full = path;
        if (!path.startsWith("/")) {
            full = this.base + full;
        }
        return new ServletContextResource(this.context, full);
    }

    public static class ServletContextResource
    implements Resource {
        private final ServletContext context;
        private final String path;

        public ServletContextResource(ServletContext context, String path) {
            this.context = context;
            this.path = path;
        }

        public ResourceResolver getResolver() {
            return new ServletContextResourceResolver(this.context, FilenameUtils.getFullPath((String)this.path));
        }

        public Type getType() {
            String ext = FilenameUtils.getExtension((String)this.path);
            if ("js".equals(ext) || "coffee".equals(ext)) {
                return Type.JS;
            }
            if ("css".equals(ext) || "less".equals(ext)) {
                return Type.CSS;
            }
            if ("json".equals(ext)) {
                return Type.JSON;
            }
            return Type.UNKNOWN;
        }

        public String getPath() {
            return this.path;
        }

        public URL getURL() throws IOException {
            return this.context.getResource(this.path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContents() throws IOException {
            InputStream in = this.context.getResourceAsStream(this.path);
            try {
                String string = IOUtils.toString((InputStream)in);
                return string;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }

        public Resource apply(Processor processor, Map<String, String> options) throws IOException {
            return processor.execute((Resource)this, options);
        }
    }
}

