/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.pipeline;

import de.matrixweb.smaller.common.GlobalOptions;
import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.ProcessDescription;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.MergingProcessor;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceGroup;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.ResourceUtil;
import de.matrixweb.smaller.resource.Resources;
import de.matrixweb.smaller.resource.SourceMerger;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFSUtils;
import de.matrixweb.vfs.VFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Pipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pipeline.class);
    private final ProcessorFactory processorFactory;
    private final Executor executor;

    public Pipeline(ProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
        this.executor = Executors.newCachedThreadPool();
    }

    public void execute(Version version, VFS vfs, ResourceResolver resolver, Manifest manifest, File targetDir) throws IOException {
        ArrayList<AtomicReference<Exception>> exceptions = new ArrayList<AtomicReference<Exception>>();
        CountDownLatch cdl = new CountDownLatch(manifest.getProcessDescriptions().size());
        try {
            for (ProcessDescription processDescription : manifest.getProcessDescriptions()) {
                exceptions.add(this.executeProcessAsyncron(cdl, manifest, processDescription, vfs, targetDir, resolver, version));
            }
            cdl.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new SmallerException("Failed to process smaller request", (Throwable)e);
        }
        for (AtomicReference atomicReference : exceptions) {
            if (atomicReference.get() == null) continue;
            Exception e = (Exception)atomicReference.get();
            if (e instanceof SmallerException) {
                throw (SmallerException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SmallerException("Failed to execute smaller process", (Throwable)e);
        }
        this.writeResults(vfs, targetDir, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicReference<Exception> executeProcessAsyncron(CountDownLatch cdl, Manifest manifest, ProcessDescription processDescription, VFS vfs, File targetDir, ResourceResolver resolver, Version version) {
        AtomicReference<Exception> exception = new AtomicReference<Exception>();
        try {
            try {
                this.execute(version, vfs, resolver, manifest, processDescription);
            }
            catch (Exception e) {
                exception.set(e);
            }
        }
        finally {
            cdl.countDown();
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Version version, VFS vfs, ResourceResolver resolver, Manifest manifest, ProcessDescription processDescription) throws IOException {
        String input = processDescription.getInputFile();
        for (ProcessDescription.Processor proc : processDescription.getProcessors()) {
            MDC.put((String)"processor", (String)proc.getName());
            try {
                Processor processor = this.processorFactory.getProcessor(proc.getName());
                LOGGER.info("Executing processor {}", (Object)proc.getName());
                Resource result = processor.execute(vfs, input == null ? null : resolver.resolve(input), this.injectGlobalOptionsFallback(version, manifest, proc.getName(), proc.getOptions()));
                input = result == null ? null : result.getPath();
            }
            finally {
                MDC.clear();
            }
        }
        if (input != null) {
            VFSUtils.write((VFile)vfs.find(processDescription.getOutputFile()), (CharSequence)resolver.resolve(input).getContents());
        }
    }

    private Map<String, Object> injectGlobalOptionsFallback(Version version, Manifest manifest, String name, Map<String, Object> options) {
        HashMap<String, Object> copy = new HashMap<String, Object>(options);
        if (manifest != null) {
            copy.put("version", version.toString());
            if ("merge".equals(name)) {
                copy.put("source", GlobalOptions.isSourceOnce((Manifest)manifest) ? "once" : "");
            }
        }
        return copy;
    }

    private void writeResults(VFS vfs, File outputDir, Manifest manifest) throws IOException {
        if (!GlobalOptions.isOutOnly((Manifest)manifest)) {
            vfs.exportFS(outputDir);
        }
        for (ProcessDescription processDescription : manifest.getProcessDescriptions()) {
            if (processDescription.getOutputFile() == null) continue;
            FileUtils.writeStringToFile((File)new File(outputDir, processDescription.getOutputFile()), (String)VFSUtils.readToString((VFile)vfs.find(processDescription.getOutputFile())));
        }
    }

    @Deprecated
    public Result execute(Version version, VFS vfs, ResourceResolver resolver, Task task) {
        try {
            return this.execute(version, vfs, resolver, ResourceUtil.createResourceGroup((Version)version, (ResourceResolver)resolver, (Task)task), task);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to run processor chain", (Throwable)e);
        }
    }

    @Deprecated
    private Result execute(Version version, VFS vfs, ResourceResolver resolver, Resources resources, Task task) {
        try {
            this.validate(task);
            List<ProcessorOptions> entries = this.setupProcessors(version, task);
            if (version.isAtLeast(Version._1_0_0)) {
                this.execute1_0(vfs, resolver, resources, entries, task);
            } else {
                this.execute0_0(vfs, resources, entries);
            }
            LOGGER.info("Finished executing pipeline");
            return this.prepareResult(vfs, resolver, task);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to run processor chain", (Throwable)e);
        }
    }

    private void execute0_0(VFS vfs, Resources resources, List<ProcessorOptions> entries) throws IOException {
        for (ProcessorOptions entry : entries) {
            for (Type type : Type.values()) {
                List res = resources.getByType(type);
                if (res.size() <= 0 || !entry.processor.supportsType(type)) continue;
                LOGGER.info("Executing processor {} for type {}", (Object)entry.name, (Object)type);
                ArrayList<Resource> results = new ArrayList<Resource>();
                for (Resource r : res) {
                    results.add(r.apply(vfs, entry.processor, entry.options));
                }
                resources.replace(res, results);
            }
        }
    }

    @Deprecated
    private void execute1_0(VFS vfs, ResourceResolver resolver, Resources resources, List<ProcessorOptions> entries, Task task) throws IOException {
        for (ProcessorOptions entry : entries) {
            for (Type type : Type.values()) {
                List res = resources.getByType(type);
                if (!entry.processor.supportsType(type)) continue;
                LOGGER.info("Executing processor {} for type {}", (Object)entry.name, (Object)type);
                ArrayList results = new ArrayList();
                ResourceGroup group = new ResourceGroup(res, new SourceMerger(GlobalOptions.isSourceOnce((Task)task)));
                group.apply(vfs, entry.processor, entry.options);
                results.addAll(group.getResources());
                resources.replace(res, results);
            }
        }
    }

    @Deprecated
    private List<ProcessorOptions> setupProcessors(Version version, Task task) {
        ArrayList<ProcessorOptions> list = new ArrayList<ProcessorOptions>();
        boolean hasJsMerger = false;
        boolean hasCssMerger = false;
        String processors = task.getProcessor();
        LOGGER.info("Building processor chain: {}", (Object)processors);
        for (String name : processors.split(",")) {
            Processor processor = this.processorFactory.getProcessor(name);
            if (processor == null) continue;
            hasJsMerger |= processor instanceof MergingProcessor && processor.supportsType(Type.JS);
            hasCssMerger |= processor instanceof MergingProcessor && processor.supportsType(Type.CSS);
            list.add(new ProcessorOptions(name, processor, this.addVersionToOptions(task.getOptionsFor(name), version)));
        }
        if (version == Version.UNDEFINED) {
            if (!hasJsMerger) {
                list.add(0, this.createTypeMerger(Type.JS));
            }
            if (!hasCssMerger) {
                list.add(0, this.createTypeMerger(Type.CSS));
            }
        }
        return list;
    }

    private Map<String, Object> addVersionToOptions(Map<String, Object> options, Version version) {
        options.put("version", version.toString());
        return options;
    }

    private ProcessorOptions createTypeMerger(Type type) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type", type.name());
        return new ProcessorOptions("merge", this.processorFactory.getProcessor("merge"), options);
    }

    @Deprecated
    private boolean validate(Task task) {
        if (CollectionUtils.exists(CollectionUtils.getCardinalityMap((Collection)CollectionUtils.collect(Arrays.asList(task.getOut()), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return FilenameUtils.getExtension((String)input.toString());
            }
        })).values(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return (Integer)object > 1;
            }
        })) {
            throw new SmallerException("Each output type must exist only once");
        }
        String[] processors = task.getProcessor().toLowerCase().split(",");
        boolean cssembedFound = false;
        for (String processor : processors) {
            if (processor.equals("cssembed")) {
                cssembedFound = true;
                continue;
            }
            if (!processor.equals("yuicompressor") || !cssembedFound) continue;
            throw new SmallerException("yuiCompressor must run before cssembed");
        }
        return true;
    }

    @Deprecated
    private Result prepareResult(VFS vfs, ResourceResolver resolver, Task task) throws IOException {
        Resources resources = new Resources();
        for (String out : task.getOut()) {
            LOGGER.info("Preparing output file: {}", (Object)out);
            String ext = FilenameUtils.getExtension((String)out);
            VFile file = this.findLastModified(vfs.find("/"), ext);
            if (file == null) continue;
            VFile target = vfs.find('/' + out);
            LOGGER.info("Copy '{}' -> '{}'", (Object)file, (Object)target);
            VFSUtils.copy((VFile)file, (VFile)target);
            resources.addResource(resolver.resolve(target.getPath()));
        }
        return new Result(resources);
    }

    private VFile findLastModified(VFile file, String ext) throws IOException {
        VFile newest = null;
        if (file.isDirectory()) {
            for (VFile child : file.getChildren()) {
                VFile temp = this.findLastModified(child, ext);
                if (newest != null && (temp == null || temp.getLastModified() <= newest.getLastModified())) continue;
                newest = temp;
            }
        } else if (ext.equals(FilenameUtils.getExtension((String)file.getName()))) {
            newest = file;
        }
        return newest;
    }

    private static class ProcessorOptions {
        private final String name;
        private final Processor processor;
        private final Map<String, Object> options;

        ProcessorOptions(String name, Processor processor, Map<String, Object> options) {
            this.name = name;
            this.processor = processor;
            this.options = options;
        }

        public String toString() {
            return this.name;
        }
    }
}

