/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.pipeline;

import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Resources;
import de.matrixweb.smaller.resource.Type;
import java.util.List;

public class Result {
    private Resources resources;

    public Result() {
    }

    public Result(Resources resources) {
        this.resources = resources;
    }

    public Resource get(Type type) {
        if (this.resources == null) {
            return null;
        }
        List res = this.resources.getByType(type);
        return res.size() > 0 ? (Resource)res.get(0) : null;
    }

    public Resource get(String mimeType) {
        if (this.resources == null) {
            return null;
        }
        if ("text/javascript".equals(mimeType)) {
            return this.get(Type.JS);
        }
        if ("text/css".equals(mimeType)) {
            return this.get(Type.CSS);
        }
        throw new IllegalArgumentException("Unmapped mime-type " + mimeType);
    }

    @Deprecated
    public final Resource getJs() {
        return this.get(Type.JS);
    }

    @Deprecated
    public final Resource getCss() {
        return this.get(Type.CSS);
    }
}

