/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.pipeline;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.MultiResource;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Resources;
import de.matrixweb.smaller.resource.SourceMerger;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pipeline.class);
    private final ProcessorFactory processorFactory;

    public Pipeline(ProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    public Result execute(ResourceResolver resolver, Task task) {
        try {
            return this.execute(this.createResourceGroup(resolver, task), task);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to run processor chain", (Throwable)e);
        }
    }

    private Resources createResourceGroup(ResourceResolver resolver, Task task) throws IOException {
        ArrayList files = new ArrayList();
        files.addAll(Arrays.asList(task.getIn()));
        SourceMerger merger = new SourceMerger(Task.GlobalOptions.isSourceOnce((Task)task));
        Resources resources = new Resources(merger.getResources(resolver, files));
        List res = resources.getByType(Type.JS);
        if (res.size() > 1) {
            resources.replace(res, new Resource[]{new MultiResource(merger, resolver, ((Resource)res.get(0)).getPath(), res)});
        }
        if ((res = resources.getByType(Type.CSS)).size() > 1) {
            resources.replace(res, new Resource[]{new MultiResource(merger, resolver, ((Resource)res.get(0)).getPath(), res)});
        }
        return resources;
    }

    public Result execute(Resources resources, Task task) {
        try {
            String processors = task.getProcessor();
            LOGGER.info("Building processor chain: {}", (Object)processors);
            this.validate(task);
            if (processors.indexOf("merge") == -1) {
                processors = "merge," + processors;
            }
            String[] stringArray = processors.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Processor processor = this.processorFactory.getProcessor(name);
                if (processor != null) {
                    Type[] typeArray = Type.values();
                    int n3 = typeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Type type = typeArray[n4];
                        List res = resources.getByType(type);
                        if (res.size() > 0 && processor.supportsType(type)) {
                            LOGGER.info("Executing processor {} for type ", (Object)name, (Object)type);
                            ArrayList<Resource> results = new ArrayList<Resource>();
                            for (Resource r : res) {
                                results.add(r.apply(processor, task.getOptionsFor(name)));
                            }
                            resources.replace(res, results);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            LOGGER.info("Finished executing pipeline");
            return new Result(resources);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to run processor chain", (Throwable)e);
        }
    }

    private boolean validate(Task task) {
        String[] processors = task.getProcessor().toLowerCase().split(",");
        boolean cssembedFound = false;
        String[] stringArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            String processor = stringArray[n2];
            if (processor.equals("cssembed")) {
                cssembedFound = true;
            } else if (processor.equals("yuicompressor") && cssembedFound) {
                throw new SmallerException("yuiCompressor must run before cssembed");
            }
            ++n2;
        }
        return true;
    }
}

