/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.client.osgi.internal;

import de.matrixweb.smaller.client.osgi.HashGenerator;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.FileUtils;

public class SourceHashGenerator
implements HashGenerator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createVersionHash(VFS vfs) {
        try {
            File temp = File.createTempFile("smaller-hash-generator", ".dir");
            try {
                temp.delete();
                temp.mkdirs();
                vfs.exportFS(temp);
                String source = this.createAllSources(temp);
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hash = digest.digest(source.getBytes("UTF-8"));
                StringBuilder hexString = new StringBuilder();
                for (int i = 0; i < hash.length; ++i) {
                    String hex = Integer.toHexString(0xFF & hash[i]);
                    if (hex.length() == 1) {
                        hexString.append('0');
                    }
                    hexString.append(hex);
                }
                String string = hexString.toString();
                return string;
            }
            catch (NoSuchAlgorithmException e) {
                throw new SmallerException("Failed to create version-hash", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new SmallerException("Failed to create version-hash", (Throwable)e);
            }
            finally {
                FileUtils.deleteDirectory((File)temp);
            }
        }
        catch (IOException e) {
            throw new SmallerException("Failed to create version-hash", (Throwable)e);
        }
    }

    String createAllSources(File dir) throws IOException {
        ArrayList files = new ArrayList(FileUtils.listFiles((File)dir, null, (boolean)true));
        Collections.sort(files);
        StringBuilder builder = new StringBuilder();
        for (File file : files) {
            builder.append(FileUtils.readFileToString((File)file));
        }
        return builder.toString();
    }
}

