/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.client.osgi.internal;

import de.matrixweb.smaller.client.osgi.BundleSelector;
import de.matrixweb.smaller.client.osgi.internal.OsgiBundleEntry;
import de.matrixweb.smaller.client.osgi.internal.ProcessorFactoryServiceTracker;
import de.matrixweb.smaller.client.osgi.internal.Servlet;
import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.ProcessDescription;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.config.ConfigFile;
import de.matrixweb.smaller.config.Environment;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.wrapped.MergingVFS;
import de.matrixweb.vfs.wrapped.WrappedSystem;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallerConfigurationInstance
implements ProcessorFactoryServiceTracker.ProcessorFactoryServiceListener {
    public static final String SMALLER_HEADER = "Smaller-Config";
    private static final Logger LOGGER = LoggerFactory.getLogger(SmallerConfigurationInstance.class);
    private final BundleContext bundleContext;
    private final Bundle smallerConfigBundle;
    private final String config;
    private Pipeline pipeline;
    private final List<ServiceHolder> services = new ArrayList<ServiceHolder>();

    public SmallerConfigurationInstance(BundleContext bundleContext, Bundle smallerConfigBundle, String config, ProcessorFactoryServiceTracker tracker) {
        this.bundleContext = bundleContext;
        this.smallerConfigBundle = smallerConfigBundle;
        this.config = config;
        tracker.addListener(this);
    }

    public void addedProcessorFactory(ProcessorFactory processorFactory) {
        this.pipeline = new Pipeline(processorFactory);
        this.updateSerlvetStatus();
    }

    public void removedProcessorFactory(ProcessorFactory processorFactory) {
        this.pipeline = null;
        this.updateSerlvetStatus();
    }

    private void updateSerlvetStatus() {
        if (this.pipeline != null) {
            LOGGER.info("Creating smaller pipeline and publishing servlet");
            this.registerServlets();
        } else {
            LOGGER.info("Disposing smaller pipeline and removing servlet");
            this.disposeServlets();
        }
    }

    private void registerServlets() {
        try {
            ConfigFile configFile = ConfigFile.read((URL)this.smallerConfigBundle.getResource(this.config));
            Manifest manifest = Manifest.fromConfigFile((ConfigFile)configFile);
            for (String envName : configFile.getBuildServer().getEnvironments()) {
                Environment env = (Environment)configFile.getEnvironments().get(envName);
                ProcessDescription processDescription = this.getProcessDescription(env, manifest);
                ServiceHolder holder = new ServiceHolder();
                holder.vfs = new VFS();
                this.setupVfs(holder.vfs, env);
                holder.servlet = new Servlet(holder.vfs, this.pipeline, processDescription);
                String alias = processDescription.getOutputFile();
                if (alias.contains("{hash}")) {
                    alias = alias.replace("{hash}", holder.servlet.getHash());
                }
                LOGGER.info("Adding Smaller Servlet for URL '{}'", (Object)alias);
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("alias", alias);
                ((Dictionary)props).put(envName, alias);
                holder.servletService = this.bundleContext.registerService(javax.servlet.Servlet.class, (Object)holder.servlet, props);
                this.services.add(holder);
            }
        }
        catch (IOException e) {
            throw new SmallerException("Failed to register smaller servlets", (Throwable)e);
        }
    }

    private ProcessDescription getProcessDescription(Environment env, Manifest manifest) {
        for (ProcessDescription processDescription : manifest.getProcessDescriptions()) {
            if (processDescription.getOutputFile() == null || !processDescription.getOutputFile().equals(env.getProcess())) continue;
            return processDescription;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupVfs(VFS vfs, Environment env) throws IOException {
        ServiceReference ref = this.bundleContext.getServiceReference(BundleSelector.class);
        try {
            BundleSelector bundleSelector = null;
            if (ref != null) {
                bundleSelector = (BundleSelector)this.bundleContext.getService(ref);
            }
            ArrayList<OsgiBundleEntry> files = new ArrayList<OsgiBundleEntry>();
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (bundleSelector != null) {
                    if (!bundleSelector.shouldInclude(env, bundle)) continue;
                    for (String folder : env.getFiles().getFolder()) {
                        if (!folder.endsWith("/")) {
                            folder = folder + '/';
                        }
                        files.add(new OsgiBundleEntry(bundle, folder, env.getFiles().getIncludes(), env.getFiles().getExcludes()));
                    }
                    continue;
                }
                for (String folder : env.getFiles().getFolder()) {
                    if (bundle.findEntries(folder, null, true) == null) continue;
                    files.add(new OsgiBundleEntry(bundle, folder, env.getFiles().getIncludes(), env.getFiles().getExcludes()));
                }
            }
            vfs.mount(vfs.find("/"), (WrappedSystem)new MergingVFS(files));
        }
        finally {
            if (ref != null) {
                this.bundleContext.ungetService(ref);
            }
        }
    }

    private void disposeServlets() {
        for (ServiceHolder holder : this.services) {
            if (holder.servletService != null) {
                holder.servletService.unregister();
                holder.servletService = null;
            }
            if (holder.servlet != null) {
                holder.servlet = null;
            }
            if (holder.vfs == null) continue;
            holder.vfs.dispose();
            holder.vfs = null;
        }
        this.services.clear();
    }

    public void dispose(ProcessorFactoryServiceTracker tracker) {
        tracker.removeListener(this);
    }

    private static class ServiceHolder {
        private Servlet servlet;
        private ServiceRegistration<javax.servlet.Servlet> servletService;
        private VFS vfs;

        private ServiceHolder() {
        }
    }
}

