/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.client.osgi.internal;

import de.matrixweb.smaller.common.ProcessDescription;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.VFSResourceResolver;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFSUtils;
import de.matrixweb.vfs.VFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet
extends HttpServlet {
    private static final long serialVersionUID = 2386876386135939230L;
    private static final Object LOCK = new Object();
    private final VFS vfs;
    private final Pipeline pipeline;
    private final ProcessDescription processDescription;
    private String buildResult;
    private String hash;

    public Servlet(VFS vfs, Pipeline pipeline, ProcessDescription processDescription) throws IOException {
        this.vfs = vfs;
        this.pipeline = pipeline;
        this.processDescription = processDescription;
        this.build();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.buildResult == null) {
            this.build();
        }
        response.setContentType(this.getContentType(request));
        PrintWriter writer = response.getWriter();
        writer.print(this.buildResult);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (this.buildResult == null) {
                this.pipeline.execute(Version.getCurrentVersion(), this.vfs, (ResourceResolver)new VFSResourceResolver(this.vfs), null, this.processDescription);
                this.buildResult = VFSUtils.readToString((VFile)this.vfs.find(this.processDescription.getOutputFile()));
                this.hash = Servlet.createVersionHash(this.buildResult);
            }
        }
    }

    private static String createVersionHash(String code) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(code.getBytes("UTF-8"));
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SmallerException("Failed to create version-hash", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SmallerException("Failed to create version-hash", (Throwable)e);
        }
    }

    String getHash() {
        return this.hash;
    }

    private String getContentType(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            if (request.getRequestURI().endsWith("js")) {
                contentType = "text/javascript";
            } else if (request.getRequestURI().endsWith("css")) {
                contentType = "text/css";
            }
        }
        return contentType;
    }
}

