/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.client.osgi.internal;

import de.matrixweb.vfs.scanner.ResourceLister;
import de.matrixweb.vfs.scanner.ResourceScanner;
import de.matrixweb.vfs.wrapped.WrappedSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiBundleEntry
implements WrappedSystem {
    private final Bundle bundle;
    private final String path;
    private final String[] includes;
    private final String[] excludes;
    private Map<String, BundleInternal> files = new HashMap<String, BundleInternal>();

    public OsgiBundleEntry(Bundle bundle, String path, String[] includes, String[] excludes) {
        this.bundle = bundle;
        this.path = path.startsWith("/") ? path : '/' + path;
        this.includes = includes;
        this.excludes = excludes;
        Enumeration urls = bundle.findEntries(this.path, null, true);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                String entry = url.getPath();
                if (entry.endsWith("/")) {
                    entry = entry.substring(0, entry.length() - 1);
                }
                this.files.put(entry, new BundleInternal(entry));
                int idx = entry.lastIndexOf(47);
                while (idx > 0) {
                    if (!this.files.containsKey(entry = entry.substring(0, idx))) {
                        this.files.put(entry, new BundleInternal(entry));
                    }
                    idx = entry.lastIndexOf(47);
                }
            }
        }
        this.files = this.filter(this.files);
        LoggerFactory.getLogger(OsgiBundleEntry.class).info("Files: " + this.files.keySet() + " <= " + bundle);
    }

    private Map<String, BundleInternal> filter(Map<String, BundleInternal> candidates) {
        HashMap<String, BundleInternal> filtered = new HashMap<String, BundleInternal>();
        for (String string : new ResourceScanner(new ResourceLister(){

            public Set<String> list(String path) {
                HashSet<String> set = new HashSet<String>();
                for (Map.Entry entry : OsgiBundleEntry.this.files.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(path) || ((String)entry.getKey()).substring(path.length()).contains("/")) continue;
                    set.add((String)entry.getKey() + (((BundleInternal)entry.getValue()).isDirectory() ? Character.valueOf('/') : ""));
                }
                return set;
            }
        }, this.includes, this.excludes).getResources()) {
            filtered.put(string, candidates.get(string));
        }
        if (filtered.size() > 0) {
            for (Map.Entry entry : candidates.entrySet()) {
                if (!((BundleInternal)entry.getValue()).isDirectory()) continue;
                filtered.put((String)entry.getKey(), (BundleInternal)entry.getValue());
            }
        }
        return filtered;
    }

    public String getName() {
        String name = this.path;
        if (this.path.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public boolean exists() {
        return this.exists(this.path);
    }

    private boolean exists(String entry) {
        return this.files.containsKey(entry) && this.bundle.getEntry(entry) != null;
    }

    public boolean isDirectory() {
        return this.isDirectory(this.path);
    }

    private boolean isDirectory(String entry) {
        if (this.files.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, BundleInternal> file : this.files.entrySet()) {
            String filePath = file.getKey();
            if (!filePath.startsWith(entry) || filePath.length() <= entry.length()) continue;
            return true;
        }
        return false;
    }

    public List<WrappedSystem> list() {
        return this.list0(this.path);
    }

    private List<WrappedSystem> list0(String entry) {
        return new ArrayList<WrappedSystem>(this.getCandidates(entry).values());
    }

    private Map<String, BundleInternal> getCandidates(String path) {
        HashMap<String, BundleInternal> candidates = new HashMap<String, BundleInternal>();
        for (Map.Entry<String, BundleInternal> file : this.files.entrySet()) {
            String[] parts;
            String filePath = file.getKey();
            if (!filePath.startsWith(path)) continue;
            if ((filePath = filePath.substring(path.length())).startsWith("/")) {
                filePath = filePath.substring(1);
            }
            if (filePath.length() <= 0 || (parts = filePath.split("/")).length != 1) continue;
            candidates.put(path + parts[0], file.getValue());
        }
        return candidates;
    }

    public long lastModified() {
        return this.lastModified(this.path);
    }

    private long lastModified(String entry) {
        try {
            LoggerFactory.getLogger(OsgiBundleEntry.class).info("Entry: " + entry + " <= " + this.bundle);
            return this.bundle.getEntry(entry).openConnection().getLastModified();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(this.path);
    }

    private InputStream getInputStream(String entry) throws IOException {
        return this.bundle.getEntry(entry).openStream();
    }

    public String toString() {
        return "[VFS-OSGiBundleEntry] " + this.bundle + ":" + this.path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleInternal
    implements WrappedSystem {
        private final String path;

        public BundleInternal(String path) {
            this.path = path;
        }

        public String getName() {
            return this.path.substring(this.path.lastIndexOf(47) + 1);
        }

        public boolean exists() {
            return OsgiBundleEntry.this.exists(this.path);
        }

        public boolean isDirectory() {
            return OsgiBundleEntry.this.isDirectory(this.path);
        }

        public List<WrappedSystem> list() {
            return OsgiBundleEntry.this.list0(this.path);
        }

        public long lastModified() {
            return OsgiBundleEntry.this.lastModified(this.path);
        }

        public InputStream getInputStream() throws IOException {
            return OsgiBundleEntry.this.getInputStream(this.path);
        }

        public String toString() {
            return "[VFS-OSGiBundleEntry] " + OsgiBundleEntry.this.bundle + ":" + this.path;
        }
    }
}

