/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.client.osgi.internal;

import de.matrixweb.smaller.client.osgi.internal.ProcessorFactoryServiceTracker;
import de.matrixweb.smaller.client.osgi.internal.SmallerConfigurationInstance;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    private ProcessorFactoryServiceTracker processorFactoryServiceTracker;
    private final Map<Bundle, SmallerConfigurationInstance> smallerBundles = new HashMap<Bundle, SmallerConfigurationInstance>();

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.processorFactoryServiceTracker = new ProcessorFactoryServiceTracker(context);
        this.processorFactoryServiceTracker.open();
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 2 && bundle.getState() != 4 && bundle.getState() != 32) continue;
            this.checkSmallerBundle(bundle);
        }
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        for (SmallerConfigurationInstance instance : this.smallerBundles.values()) {
            instance.dispose(this.processorFactoryServiceTracker);
        }
        this.smallerBundles.clear();
        if (this.processorFactoryServiceTracker != null) {
            this.processorFactoryServiceTracker.close();
            this.processorFactoryServiceTracker = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                this.checkSmallerBundle(event.getBundle());
                break;
            }
            case 16: {
                if (!this.smallerBundles.containsKey(event.getBundle())) break;
                LOGGER.info("Smaller-Bundle removed: {}", (Object)event.getBundle());
                this.smallerBundles.remove(event.getBundle()).dispose(this.processorFactoryServiceTracker);
            }
        }
    }

    private void checkSmallerBundle(Bundle bundle) {
        String smallerConfig = (String)bundle.getHeaders().get("Smaller-Config");
        if (smallerConfig != null) {
            LOGGER.info("New Smaller-Bundle found: {} [config={}]", (Object)bundle, (Object)smallerConfig);
            this.smallerBundles.put(bundle, new SmallerConfigurationInstance(this.context, bundle, smallerConfig, this.processorFactoryServiceTracker));
        }
    }
}

