/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.coffeescript;

import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class CoffeescriptProcessor
implements Processor {
    private final String version;
    private NodeJsExecutor node;

    public CoffeescriptProcessor() {
        this("1.7.1");
    }

    public CoffeescriptProcessor(String version) {
        this.version = version;
    }

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        if (this.node == null) {
            try {
                this.node = new NodeJsExecutor();
                this.node.setModule(this.getClass(), "coffeescript-" + this.version, "coffeescript.js");
            }
            catch (IOException e) {
                this.node = null;
                throw new SmallerException("Failed to setup node for coffeescript", (Throwable)e);
            }
        }
        String outfile = this.node.run(vfs, resource != null ? resource.getPath() : null, options);
        Resource result = resource;
        if (resource != null) {
            if (outfile != null) {
                result = resource.getResolver().resolve(outfile);
            } else if (FilenameUtils.isExtension((String)resource.getPath(), (String)"coffee")) {
                result = resource.getResolver().resolve(FilenameUtils.removeExtension((String)resource.getPath()) + ".js");
            }
        }
        return result;
    }

    public void dispose() {
        if (this.node != null) {
            this.node.dispose();
        }
    }
}

