/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

final class ServletHandlerRequest
extends HttpServletRequestWrapper {
    private final String alias;
    private String contextPath;
    private String pathInfo;
    private boolean pathInfoCalculated = false;

    public ServletHandlerRequest(HttpServletRequest req, String alias) {
        super(req);
        this.alias = alias;
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return super.getAuthType();
    }

    public String getContextPath() {
        if (this.contextPath == null) {
            String context = super.getContextPath();
            String servlet = super.getServletPath();
            this.contextPath = context.length() == 0 ? servlet : (servlet.length() == 0 ? context : context + servlet);
        }
        return this.contextPath;
    }

    public String getPathInfo() {
        if (!this.pathInfoCalculated) {
            this.pathInfo = this.calculatePathInfo();
            this.pathInfoCalculated = true;
        }
        return this.pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        return null == info ? null : this.getRealPath(info);
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public String getServletPath() {
        if ("/".equals(this.alias)) {
            return "";
        }
        return this.alias;
    }

    private String calculatePathInfo() {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null) {
            if (!"/".equals(this.alias)) {
                pathInfo = pathInfo.substring(this.alias.length());
            }
            if (pathInfo.length() == 0) {
                pathInfo = null;
            }
        }
        return pathInfo;
    }
}

