/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.browserify;

import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.MergingProcessor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFile;
import java.io.IOException;
import java.util.Map;

public class BrowserifyProcessor
implements MergingProcessor {
    private final String version;
    private NodeJsExecutor node;

    public BrowserifyProcessor() {
        this("3.24.9");
    }

    public BrowserifyProcessor(String version) {
        this.version = version;
    }

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        VFile file;
        String outfile;
        if (this.node == null) {
            try {
                this.node = new NodeJsExecutor();
                this.node.setModule(this.getClass(), "browserify-" + this.version, "browserify.js");
            }
            catch (IOException e) {
                this.node = null;
                throw new SmallerException("Failed to setup node for browserify", (Throwable)e);
            }
        }
        if ((outfile = this.node.run(vfs, resource != null ? resource.getPath() : null, options)) != null && !(file = vfs.find('/' + outfile)).exists()) {
            throw new SmallerException("BrowserifyProcessor result does not exists");
        }
        return resource == null || outfile == null ? resource : resource.getResolver().resolve('/' + outfile);
    }

    public void dispose() {
        if (this.node != null) {
            this.node.dispose();
            this.node = null;
        }
    }
}

