/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.kernel.maven.impl;

import de.matrixweb.osgi.kernel.maven.impl.Artifact;
import de.matrixweb.osgi.kernel.maven.impl.Dependency;
import de.matrixweb.osgi.kernel.maven.impl.Filter;
import de.matrixweb.osgi.kernel.maven.impl.MavenUtils;
import de.matrixweb.osgi.kernel.maven.impl.Pom;
import de.matrixweb.osgi.kernel.maven.impl.PomParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PomResolver {
    private static final SAXParserFactory PARSER_FACTORY = SAXParserFactory.newInstance();
    private final String repository;
    private final Map<String, Pom> resolved = new HashMap<String, Pom>();

    public PomResolver(String repository) {
        this.repository = repository;
    }

    public Pom resolvePom(Artifact artifact) throws IOException, ParserConfigurationException {
        return this.resolvePom(artifact, null);
    }

    public Pom resolvePom(Artifact artifact, InputStream input) throws IOException, ParserConfigurationException {
        String urn = MavenUtils.toURN(artifact);
        if (!this.resolved.containsKey(urn)) {
            this.resolved.put(urn, this.internalResolve(artifact, input));
        }
        return this.resolved.get(urn);
    }

    private Pom internalResolve(Artifact artifact, InputStream input) throws IOException, ParserConfigurationException {
        block7: {
            Pom pom;
            InputStream is = input == null ? new URL(MavenUtils.toUrl(this.repository, artifact, "pom")).openStream() : input;
            try {
                Pom pom2 = new Pom(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                PARSER_FACTORY.newSAXParser().parse(is, (DefaultHandler)new PomParser(pom2));
                if (pom2.getParent() != null) {
                    pom2.setParent(this.internalResolve(pom2.getParent(), null));
                }
                pom = pom2;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (SAXException sAXException) {
                    System.out.println("Invalid pom " + MavenUtils.toURN(artifact) + " ... skipping");
                    break block7;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Missing pom " + MavenUtils.toURN(artifact) + " ... skipping");
                }
            }
            is.close();
            return pom;
        }
        return null;
    }

    public Set<Pom> getFilteredDependencies(Pom pom, Filter filter) throws IOException, ParserConfigurationException {
        HashSet<Pom> set = new HashSet<Pom>();
        HashSet<String> done = new HashSet<String>();
        ConcurrentLinkedQueue<DependencyPair> inProcess = new ConcurrentLinkedQueue<DependencyPair>();
        inProcess.add(new DependencyPair(null, pom));
        while (!inProcess.isEmpty()) {
            DependencyPair current = (DependencyPair)inProcess.poll();
            for (Dependency dependency : current.pom.getDependencies()) {
                Pom resolved;
                if (done.contains(dependency.getGroupArtifactKey()) || !filter.accept(dependency) || this.excludesArtifact(current, dependency) || (resolved = this.resolvePom(dependency)) == null) continue;
                done.add(dependency.getGroupArtifactKey());
                set.add(resolved);
                inProcess.add(new DependencyPair(dependency, resolved));
            }
        }
        return set;
    }

    private boolean excludesArtifact(DependencyPair pair, Dependency dependency) {
        return pair.dependency != null && pair.dependency.excludes(dependency);
    }

    private static class DependencyPair {
        private final Dependency dependency;
        private final Pom pom;

        DependencyPair(Dependency dependency, Pom pom) {
            this.dependency = dependency;
            this.pom = pom;
        }
    }
}

