/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.kernel.maven.impl;

import de.matrixweb.osgi.kernel.maven.impl.Artifact;
import de.matrixweb.osgi.kernel.maven.impl.Dependency;
import de.matrixweb.osgi.kernel.maven.impl.Filter;
import de.matrixweb.osgi.kernel.maven.impl.Pom;
import de.matrixweb.osgi.kernel.maven.impl.PomResolver;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;

public class MavenUtils {
    public static String toURN(Artifact artifact) {
        StringBuilder sb = new StringBuilder("mvn:").append(artifact.getGroupId()).append(':').append(artifact.getArtifactId()).append(':').append(artifact.getVersion());
        if (!"jar".equals(artifact.getPackagingOrType())) {
            sb.append(':').append(artifact.getPackagingOrType());
        }
        return sb.toString();
    }

    public static String toUrl(String repository, Artifact artifact, String type) {
        return String.valueOf(repository) + '/' + artifact.getGroupId().replace('.', '/') + '/' + artifact.getArtifactId() + '/' + artifact.getVersion() + '/' + artifact.getArtifactId() + '-' + artifact.getVersion() + '.' + type;
    }

    public static String dump(PomResolver resolver, Pom pom) throws IOException, ParserConfigurationException {
        return MavenUtils.dump(resolver, new Filter.AcceptAll(), pom);
    }

    public static String dump(PomResolver resolver, Filter filter, Pom pom) throws IOException, ParserConfigurationException {
        String padding = MavenUtils.createPadding(0);
        StringBuilder sb = new StringBuilder(padding).append(pom.toString());
        MavenUtils.dumpDependencys(sb, padding, 0, resolver, filter, pom);
        return sb.toString();
    }

    private static String dump(int indent, PomResolver resolver, Filter filter, Pom dependency) throws IOException, ParserConfigurationException {
        String padding = MavenUtils.createPadding(indent);
        StringBuilder sb = new StringBuilder(padding).append(dependency.toString());
        MavenUtils.dumpDependencys(sb, padding, indent, resolver, filter, dependency);
        return sb.toString();
    }

    private static String createPadding(int indent) {
        StringBuilder padding = new StringBuilder();
        int i = 0;
        while (i < indent) {
            padding.append("  ");
            ++i;
        }
        return padding.toString();
    }

    private static void dumpDependencys(StringBuilder sb, String padding, int indent, PomResolver resolver, Filter filter, Pom pom) throws IOException, ParserConfigurationException {
        for (Dependency dependency : pom.getDependencies()) {
            Pom resolved;
            if (!filter.accept(dependency) || (resolved = resolver.resolvePom(dependency)) == null) continue;
            sb.append("\n").append(padding).append(MavenUtils.dump(indent + 1, resolver, filter, resolved));
        }
    }
}

