/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.lessjs;

import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import de.matrixweb.smaller.javascript.JavaScriptExecutorFast;
import de.matrixweb.smaller.resource.MergingProcessor;
import de.matrixweb.smaller.resource.ProcessorUtil;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceGroup;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessjsProcessor
implements MergingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LessjsProcessor.class);
    private static final String WIN_LOC_HREF_FIX = "protocol://host:port/";
    private final String version;
    private final ProxyResourceResolver proxy = new ProxyResourceResolver();
    private JavaScriptExecutor executor;
    private NodeJsExecutor node;

    public LessjsProcessor() {
        this("1.6.1");
    }

    public LessjsProcessor(String version) {
        this.version = version;
    }

    private boolean runWithNode() {
        return !this.version.startsWith("1.3") && !this.version.startsWith("1.4") && !this.version.equals("trunk");
    }

    private void configureWithNode() {
        if (this.node == null) {
            LOGGER.info("Setup lessjs ({}) with node", (Object)this.version);
            try {
                this.node = new NodeJsExecutor();
                this.node.setModule(this.getClass(), "lessjs-" + this.version);
            }
            catch (IOException e) {
                this.node = null;
                throw new SmallerException("Failed to conigure node for lessjs-" + this.version, (Throwable)e);
            }
        }
    }

    private void configureWithJs() {
        if (this.executor == null) {
            LOGGER.info("Setup lessjs ({}) with v8/rhino", (Object)this.version);
            this.executor = new JavaScriptExecutorFast("less-" + this.version, 9, LessjsProcessor.class);
            this.executor.addGlobalFunction("resolve", (Object)new ResolveFunctor(this.proxy));
            this.executor.addScriptSource("win_loc_href_fix = 'protocol://host:port/';", "win_loc_href_fix");
            this.executor.addScriptFile(this.getClass().getResource("/lessjs/less-env.js"));
            this.executor.addScriptFile(this.getClass().getResource("/lessjs/less-" + this.version + ".js"));
            this.executor.addCallScript("lessIt(%s);");
        }
    }

    public boolean supportsType(Type type) {
        return type == Type.CSS;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        if (this.runWithNode()) {
            this.configureWithNode();
        } else {
            this.configureWithJs();
        }
        List<Resource> resources = null;
        resources = resource instanceof ResourceGroup ? ((ResourceGroup)resource).getResources() : Arrays.asList(resource);
        final Resource input = (Resource)resources.get(0);
        if (this.runWithNode()) {
            return input.getResolver().resolve('/' + this.node.run(vfs, input.getPath(), options));
        }
        return ProcessorUtil.process((VFS)vfs, (Resource)input, (String)"less", (String)"css", (ProcessorUtil.ProcessorCallback)new ProcessorUtil.ProcessorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Reader reader, Writer writer) throws IOException {
                LessjsProcessor.this.proxy.setResolver(input.getResolver());
                try {
                    StringWriter tempWriter = new StringWriter();
                    LessjsProcessor.this.executor.run((Reader)new StringReader(input.getContents()), (Writer)tempWriter);
                    writer.write(tempWriter.toString().replace(LessjsProcessor.WIN_LOC_HREF_FIX, ""));
                }
                finally {
                    LessjsProcessor.this.proxy.removeResolver();
                }
            }
        });
    }

    public void dispose() {
        if (this.node != null) {
            this.node.dispose();
        }
        if (this.executor != null) {
            this.executor.dispose();
        }
    }

    private static class ProxyResourceResolver
    implements ResourceResolver {
        private final ThreadLocal<ResourceResolver> resolver = new ThreadLocal();

        private ProxyResourceResolver() {
        }

        public Resource resolve(String path) {
            return this.resolver.get().resolve(path);
        }

        public File writeAll() {
            throw new UnsupportedOperationException();
        }

        private void setResolver(ResourceResolver resolver) {
            this.resolver.set(resolver);
        }

        private void removeResolver() {
            this.resolver.remove();
        }
    }

    public static class ResolveFunctor {
        private final ResourceResolver resolver;

        private ResolveFunctor(ResourceResolver resolver) {
            this.resolver = resolver;
        }

        public String resolve(String input) {
            try {
                return this.resolver.resolve(input.replace(LessjsProcessor.WIN_LOC_HREF_FIX, "")).getContents();
            }
            catch (IOException e) {
                throw new SmallerException("Failed to resolve resource '" + input + "'", (Throwable)e);
            }
        }
    }
}

