/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.kernel.maven.impl;

import de.matrixweb.osgi.kernel.maven.impl.Artifact;
import de.matrixweb.osgi.kernel.maven.impl.Dependency;
import de.matrixweb.osgi.kernel.maven.impl.MavenUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Pom
extends Artifact {
    private Pom parent;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Dependency> managedDependencies = new HashMap<String, Dependency>();
    private final Map<String, Dependency> dependencies = new HashMap<String, Dependency>();

    public Pom() {
        super("jar");
    }

    public Pom(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version, "jar");
        this.initProperties();
    }

    private void initProperties() {
        this.addProperty("project.groupId", this.getGroupId());
        this.addProperty("pom.groupId", this.getGroupId());
        this.addProperty("groupId", this.getGroupId());
        this.addProperty("project.artifactId", this.getArtifactId());
        this.addProperty("pom.artifactId", this.getArtifactId());
        this.addProperty("artifactId", this.getArtifactId());
        this.addProperty("project.version", this.getVersion());
        this.addProperty("pom.version", this.getVersion());
        this.addProperty("version", this.getVersion());
    }

    @Override
    public final String getGroupId() {
        return this.resolveProperties(super.getGroupId());
    }

    @Override
    public final String getArtifactId() {
        return this.resolveProperties(super.getArtifactId());
    }

    @Override
    public final String getVersion() {
        return this.resolveProperties(super.getVersion());
    }

    public String resolveProperties(String input) {
        int start;
        String result = input;
        if (result != null && (start = result.indexOf("${")) > -1) {
            int pos = 0;
            StringBuilder sb = new StringBuilder();
            while (start > -1) {
                int end = result.indexOf(125, start);
                String match = result.substring(start + 2, end);
                String replacement = this.getReplacement(match);
                if (replacement != null) {
                    sb.append(result.substring(pos, start)).append(replacement);
                } else {
                    sb.append(result.substring(pos, end + 1));
                }
                pos = end + 1;
                start = result.indexOf("${", pos);
            }
            String done = sb.toString();
            result = !done.equals(result) ? this.resolveProperties(sb.toString()) : done;
        }
        return result;
    }

    protected final String getReplacement(String name) {
        return this.getProperties().get(name);
    }

    public Pom getParent() {
        return this.parent;
    }

    public void setParent(Pom parent) {
        this.parent = parent;
    }

    public String getPackaging() {
        return this.getPackagingOrType();
    }

    public final void setPackaging(String packaging) {
        this.setPackagingOrType(packaging);
    }

    public void addManagedDependency(Dependency managedDependency) {
        this.managedDependencies.put(managedDependency.getGroupArtifactKey(), managedDependency);
    }

    public Map<String, Dependency> getManagedDependencies() {
        HashMap<String, Dependency> deps = new HashMap<String, Dependency>();
        if (this.getParent() != null) {
            deps.putAll(this.getParent().getManagedDependencies());
        }
        deps.putAll(this.managedDependencies);
        return deps;
    }

    public Collection<Dependency> getDependencies() {
        LinkedList<Dependency> list = new LinkedList<Dependency>();
        if (this.getParent() != null) {
            list.addAll(this.getParent().getDependencies());
        }
        list.addAll(this.dependencies.values());
        return list;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.put(dependency.getGroupArtifactKey(), dependency);
    }

    public final Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.getParent() != null) {
            props.putAll(this.getParent().getProperties());
        }
        props.putAll(this.properties);
        return props;
    }

    public final void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public int hashCode() {
        int result = 1;
        String urn = MavenUtils.toURN(this);
        result = 31 * result + urn.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pom other = (Pom)obj;
        return MavenUtils.toURN(this).equals(MavenUtils.toURN(other));
    }

    @Override
    public String toString() {
        return MavenUtils.toURN(this);
    }
}

