/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.kernel.maven.impl;

import de.matrixweb.osgi.kernel.maven.MavenInstaller;
import de.matrixweb.osgi.kernel.maven.impl.Filter;
import de.matrixweb.osgi.kernel.maven.impl.MavenUtils;
import de.matrixweb.osgi.kernel.maven.impl.Pom;
import de.matrixweb.osgi.kernel.maven.impl.PomResolver;
import de.matrixweb.osgi.kernel.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;

public class MavenInstallerImpl
implements MavenInstaller {
    private final String repository;
    private final Framework framework;

    public MavenInstallerImpl(String repository, Framework framework) {
        this.repository = repository;
        this.framework = framework;
    }

    @Override
    public void installOrUpdate(String command) throws IOException {
        try {
            this.startOrUpdate(this.install(command), true);
        }
        catch (BundleException e) {
            Logger.log(e);
        }
    }

    @Override
    public void installOrUpdate(boolean update, File ... files) throws IOException {
        HashSet<BundleTask> tasks = new HashSet<BundleTask>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(file);
                try {
                    Set<BundleTask> result = this.installFromJarFile(jar);
                    tasks.addAll(result);
                    if (result.isEmpty()) {
                        try {
                            tasks.add(this.installNonMavenBundle(file));
                        }
                        catch (BundleException e) {
                            Logger.log(e);
                        }
                    }
                }
                finally {
                    jar.close();
                }
            }
            ++n2;
        }
        this.startOrUpdate(tasks, update);
    }

    private BundleTask installNonMavenBundle(File file) throws BundleException {
        String location = file.toURI().toString();
        BundleTask task = new BundleTask();
        task.bundle = this.framework.getBundleContext().getBundle(location);
        if (task.bundle == null) {
            task.bundle = this.framework.getBundleContext().installBundle(location);
            task.installed = true;
        }
        return task;
    }

    private Set<BundleTask> installFromJarFile(JarFile jar) throws IOException {
        InputStream input = null;
        Pom pom = null;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.getName().endsWith("pom.xml")) {
                input = jar.getInputStream(entry);
            }
            if (!entry.getName().endsWith("pom.properties")) continue;
            InputStream is = jar.getInputStream(entry);
            try {
                Properties props = new Properties();
                props.load(is);
                pom = new Pom(props.getProperty("groupId"), props.getProperty("artifactId"), props.getProperty("version"));
            }
            finally {
                is.close();
            }
        }
        if (pom != null && input != null) {
            try {
                return this.install(pom, input);
            }
            catch (BundleException e) {
                Logger.log(e);
            }
        }
        if (input != null) {
            input.close();
        }
        return Collections.emptySet();
    }

    public Set<BundleTask> install(String command) throws BundleException, IOException {
        String[] parts = command.split(":");
        if ("mvn".equals(parts[0])) {
            Pom pom = new Pom(parts[1], parts[2], parts[3]);
            return this.install(pom, null);
        }
        return Collections.emptySet();
    }

    private Set<BundleTask> install(Pom pom, InputStream input) throws BundleException, IOException {
        HashSet<BundleTask> tasks = new HashSet<BundleTask>();
        try {
            PomResolver resolver = new PomResolver(this.repository);
            Pom rpom = resolver.resolvePom(pom, input);
            tasks.add(this.installBundle(MavenUtils.toURN(rpom), rpom));
            List<String> embedded = this.getEmbeddedDependencies(((BundleTask)tasks.iterator().next()).bundle);
            if (!"pom".equals(rpom.getPackaging())) {
                tasks.add(this.installBundle(MavenUtils.toURN(rpom), rpom));
            }
            LinkedList<Pom> requiredDependencies = new LinkedList<Pom>();
            for (Pom dependency : resolver.getFilteredDependencies(rpom, new Filter.CompoundFilter(new Filter.AcceptScopes("compile", "runtime"), new Filter.NotAcceptTypes("pom"), new Filter.AcceptOptional(false)))) {
                if (embedded.contains(MavenUtils.toURN(dependency))) continue;
                requiredDependencies.add(resolver.resolvePom(dependency));
            }
            for (Pom dep : requiredDependencies) {
                tasks.add(this.installBundle(MavenUtils.toURN(dep), dep));
            }
        }
        catch (ParserConfigurationException e) {
            Logger.log(e);
        }
        return tasks;
    }

    public void startOrUpdate(Set<BundleTask> tasks, boolean update) {
        for (BundleTask task : tasks) {
            try {
                if (task.bundle == null) continue;
                if (task.installed) {
                    this.start(task);
                    continue;
                }
                if (!update) continue;
                this.update(task);
            }
            catch (BundleException e) {
                Logger.log(e);
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
        this.refresh(tasks);
    }

    private void start(BundleTask task) throws BundleException {
        if (task.bundle.getHeaders().get("Fragment-Host") == null) {
            System.out.println("Starting bundle " + (task.pom != null ? MavenUtils.toURN(task.pom) : task.bundle.getLocation()));
            task.bundle.start();
        }
    }

    private void update(BundleTask task) throws IOException, BundleException {
        InputStream in = null;
        if (task.pom != null) {
            in = new URL(MavenUtils.toUrl(this.repository, task.pom, "jar")).openStream();
        }
        try {
            System.out.println("Updating bundle " + (task.pom != null ? MavenUtils.toURN(task.pom) : task.bundle.getLocation()));
            task.bundle.update(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void refresh(Set<BundleTask> tasks) {
        FrameworkWiring fw = this.framework.adapt(FrameworkWiring.class);
        if (fw != null) {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            for (BundleTask task : tasks) {
                bundles.add(task.bundle);
            }
            fw.refreshBundles(bundles, new FrameworkListener[0]);
        }
    }

    private BundleTask installBundle(String location, Pom pom) throws IOException, BundleException {
        BundleTask task = new BundleTask();
        task.pom = pom;
        task.bundle = this.framework.getBundleContext().getBundle(location);
        if (task.bundle == null) {
            System.out.println("Installing bundle " + MavenUtils.toURN(pom));
            InputStream in = new URL(MavenUtils.toUrl(this.repository, pom, "jar")).openStream();
            try {
                task.bundle = this.framework.getBundleContext().installBundle(location, in);
                task.installed = true;
            }
            finally {
                in.close();
            }
        }
        return task;
    }

    private List<String> getEmbeddedDependencies(Bundle bundle) {
        LinkedList<String> list = new LinkedList<String>();
        String embeddedArtifacts = bundle.getHeaders().get("Embedded-Artifacts");
        if (embeddedArtifacts != null) {
            String[] embedded;
            String[] stringArray = embedded = embeddedArtifacts.split(",");
            int n = embedded.length;
            int n2 = 0;
            while (n2 < n) {
                String def = stringArray[n2];
                String[] parts = def.split(";");
                String groupId = parts[1].substring(3, parts[1].length() - 1);
                String artifactId = parts[2].substring(3, parts[2].length() - 1);
                String version = parts[3].substring(3, parts[3].length() - 1);
                list.add("mvn:" + groupId + ':' + artifactId + ':' + version);
                ++n2;
            }
        }
        return list;
    }

    public static class BundleTask {
        private Pom pom;
        private Bundle bundle;
        private boolean installed = false;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.pom == null ? 0 : this.pom.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BundleTask other = (BundleTask)obj;
            return !(this.pom == null ? other.pom != null : !this.pom.equals(other.pom));
        }

        public String toString() {
            return this.pom.toString();
        }
    }
}

