/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.cssembed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nczonline.web.datauri.DataURIGenerator;

public class CSSURLEmbedder {
    public static final int DATAURI_OPTION = 1;
    public static final int MHTML_OPTION = 2;
    public static final int SKIP_MISSING_OPTION = 4;
    public static final int DEFAULT_MAX_URI_LENGTH = 32768;
    public static final String PROC_DIRECTIVE_PREFIX = "CssEmbed";
    public static final String PROC_DIRECTIVE_SKIP = "SKIP";
    protected static String MHTML_SEPARATOR = "CSSEmbed_Image";
    private static HashSet<String> imageTypes = new HashSet();
    private boolean verbose = false;
    private String code = null;
    private int options = 1;
    private String mhtmlRoot = "";
    private String outputFilename = "";
    private int maxUriLength = 32768;
    private int maxImageSize;

    public CSSURLEmbedder(Reader in) throws IOException {
        this(in, false);
    }

    public CSSURLEmbedder(Reader in, int options) throws IOException {
        this(in, false);
    }

    public CSSURLEmbedder(Reader in, boolean verbose) throws IOException {
        this(in, 1, verbose);
    }

    public CSSURLEmbedder(Reader in, int options, boolean verbose) throws IOException {
        this(in, options, verbose, 0);
    }

    public CSSURLEmbedder(Reader in, int options, boolean verbose, int maxUriLength) throws IOException {
        this(in, options, verbose, maxUriLength, 0);
    }

    public CSSURLEmbedder(Reader in, int options, boolean verbose, int maxUriLength, int maxImageSize) throws IOException {
        this.code = this.readCode(in);
        this.verbose = verbose;
        this.options = options;
        this.maxUriLength = maxUriLength;
        this.maxImageSize = maxImageSize;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
    }

    private boolean hasOption(int option) {
        return (this.options & option) > 0;
    }

    public String getMHTMLRoot() {
        return this.mhtmlRoot;
    }

    public void setMHTMLRoot(String mhtmlRoot) {
        this.mhtmlRoot = mhtmlRoot;
    }

    public String getFilename() {
        return this.outputFilename;
    }

    public void setFilename(String filename) {
        this.outputFilename = filename;
    }

    public void embedImages(Writer out) throws IOException {
        this.embedImages(out, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void embedImages(Writer out, String root) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(this.code));
        StringBuilder builder = new StringBuilder();
        StringBuilder mhtmlHeader = new StringBuilder();
        HashMap<String, Integer> foundMedia = new HashMap<String, Integer>();
        int lineNum = 1;
        int conversions = 0;
        if (this.hasOption(2)) {
            mhtmlHeader.append("/*\n");
            mhtmlHeader.append("Content-Type: multipart/related; boundary=\"");
            mhtmlHeader.append(MHTML_SEPARATOR);
            mhtmlHeader.append("\"\n\n");
        }
        while ((line = reader.readLine()) != null) {
            Pattern checkForSkip;
            Matcher skipMatch;
            int start = 0;
            int pos = line.indexOf("url(", start);
            if (lineNum > 1) {
                builder.append("\n");
            }
            if ((skipMatch = (checkForSkip = Pattern.compile("\\/\\*.*CssEmbed.*SKIP.*\\*\\/", 2)).matcher(line)).find()) {
                builder.append(line);
                if (this.verbose) {
                    System.err.println("[INFO] line #" + lineNum + " skipped due to SKIP directive (" + PROC_DIRECTIVE_PREFIX + ": " + PROC_DIRECTIVE_SKIP + ")");
                }
            } else if (pos > -1) {
                while (pos > -1) {
                    String uriString;
                    builder.append(line.substring(start, pos += 4));
                    int npos = line.indexOf(")", pos);
                    String url = line.substring(pos, npos).trim();
                    if (url.startsWith("\"")) {
                        if (!url.endsWith("\"")) throw new IOException("Invalid CSS URL format (" + url + ") at line " + lineNum + ", col " + pos + ".");
                        url = url.substring(1, url.length() - 1);
                    } else if (url.startsWith("'")) {
                        if (!url.endsWith("'")) throw new IOException("Invalid CSS URL format (" + url + ") at line " + lineNum + ", col " + pos + ".");
                        url = url.substring(1, url.length() - 1);
                    }
                    if (foundMedia.containsKey(url) && this.verbose) {
                        System.err.println("[WARNING] Duplicate URL '" + url + "' found at line " + lineNum + ", previously declared at line " + foundMedia.get(url) + ".");
                    }
                    foundMedia.put(url, lineNum);
                    String newUrl = url;
                    if (this.verbose) {
                        System.err.println("[INFO] Found URL '" + url + "' at line " + lineNum + ", col " + pos + ".");
                    }
                    if (url.indexOf("http:") != 0 && root != null) {
                        newUrl = root + url;
                        if (this.verbose) {
                            System.err.println("[INFO] Applying root to URL, URL is now '" + newUrl + "'.");
                        }
                    }
                    if ((uriString = this.getImageURIString(newUrl, url)).startsWith("data:")) {
                        if (this.maxUriLength > 0 && uriString.length() > this.maxUriLength) {
                            if (this.verbose) {
                                System.err.println("[WARNING] File " + newUrl + " creates a data URI larger than " + this.maxUriLength + " bytes. Skipping.");
                            }
                            builder.append(url);
                        } else if (this.hasOption(2)) {
                            String entryName = this.getFilename(url);
                            mhtmlHeader.append("--");
                            mhtmlHeader.append(MHTML_SEPARATOR);
                            mhtmlHeader.append("\nContent-Location:");
                            mhtmlHeader.append(entryName);
                            mhtmlHeader.append("\nContent-Transfer-Encoding:base64\n\n");
                            mhtmlHeader.append(uriString.substring(uriString.indexOf(",") + 1));
                            mhtmlHeader.append("\n");
                            builder.append("mhtml:");
                            builder.append(this.getMHTMLPath());
                            builder.append("!");
                            builder.append(entryName);
                            ++conversions;
                        } else if (this.hasOption(1)) {
                            builder.append(uriString);
                            ++conversions;
                        }
                    } else {
                        builder.append(uriString);
                    }
                    start = npos;
                    pos = line.indexOf("url(", start);
                }
                if (start < line.length()) {
                    builder.append(line.substring(start));
                }
            } else {
                builder.append(line);
            }
            ++lineNum;
        }
        reader.close();
        if (this.hasOption(2) && conversions > 0) {
            mhtmlHeader.append("\n--");
            mhtmlHeader.append(MHTML_SEPARATOR);
            mhtmlHeader.append("--\n");
            mhtmlHeader.append("*/\n");
            out.write(mhtmlHeader.toString());
        }
        if (this.verbose) {
            System.err.println("[INFO] Converted " + conversions + " images to data URIs.");
        }
        out.write(builder.toString());
    }

    String getImageURIString(String url, String originalUrl) throws IOException {
        if (CSSURLEmbedder.isImage(url)) {
            DataURIGenerator.setVerbose((boolean)this.verbose);
            StringWriter writer = new StringWriter();
            try {
                if (url.startsWith("http://")) {
                    if (this.verbose) {
                        System.err.println("[INFO] Downloading '" + url + "' to generate data URI.");
                    }
                    DataURIGenerator.generate((URL)new URL(url), (Writer)writer);
                } else {
                    if (this.verbose) {
                        System.err.println("[INFO] Opening file '" + url + "' to generate data URI.");
                    }
                    File file = new File(url);
                    if (this.verbose && !file.isFile()) {
                        System.err.println("[INFO] Could not find file '" + file.getCanonicalPath() + "'.");
                    }
                    if (this.maxImageSize > 0 && file.length() > (long)this.maxImageSize) {
                        if (this.verbose) {
                            System.err.println("[INFO] File '" + originalUrl + "' is larger than " + this.maxImageSize + " bytes. Skipping.");
                        }
                        writer.write(originalUrl);
                    } else {
                        DataURIGenerator.generate((File)new File(url), (Writer)writer);
                    }
                }
                if (this.verbose) {
                    System.err.println("[INFO] Generated data URI for '" + url + "'.");
                }
            }
            catch (FileNotFoundException e) {
                if (this.hasOption(4)) {
                    if (this.verbose) {
                        System.err.println("[INFO] Could not find file. " + e.getMessage() + " Skipping.");
                    }
                    writer.write(originalUrl);
                }
                throw e;
            }
            return writer.toString();
        }
        if (this.verbose) {
            System.err.println("[INFO] URL '" + originalUrl + "' is not an image, skipping.");
        }
        return originalUrl;
    }

    static boolean isImage(String url) {
        int startPos = url.lastIndexOf(".") + 1;
        int endPos = url.lastIndexOf("?");
        if (endPos == -1 || endPos <= startPos) {
            endPos = url.length();
        }
        String fileType = url.substring(startPos, endPos);
        return imageTypes.contains(fileType);
    }

    private String getFilename(String path) {
        if (path.indexOf("/") > -1) {
            return path.substring(path.lastIndexOf("/") + 1);
        }
        if (path.indexOf("\\") > -1) {
            return path.substring(path.lastIndexOf("\\") + 1);
        }
        return path;
    }

    private String getMHTMLPath() {
        String result = this.mhtmlRoot;
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        result = result + this.outputFilename;
        return result;
    }

    private String readCode(Reader in) throws IOException {
        int c;
        StringBuilder builder = new StringBuilder();
        while ((c = in.read()) != -1) {
            builder.append((char)c);
        }
        in.close();
        return builder.toString();
    }

    static {
        imageTypes.add("jpg");
        imageTypes.add("jpeg");
        imageTypes.add("gif");
        imageTypes.add("png");
    }
}

