/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.closure;

import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.ProcessorUtil;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClosureProcessor.class);
    private static final LoggerOutputStream LOGGER_OUTPUT_STREAM = new LoggerOutputStream();

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(VFS vfs, Resource resource, final Map<String, Object> options) throws IOException {
        return ProcessorUtil.process((VFS)vfs, (Resource)resource, (String)"js", (ProcessorUtil.ProcessorCallback)new ProcessorUtil.ProcessorCallback(){

            public void call(Reader reader, Writer writer) throws IOException {
                ClosureProcessor.this.compile(reader, writer, options);
            }
        });
    }

    public void dispose() {
    }

    private void compile(Reader reader, Writer writer, Map<String, Object> options) throws IOException {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler(new PrintStream((OutputStream)LOGGER_OUTPUT_STREAM, false, "UTF-8"));
        CompilerOptions compilerOptions = new CompilerOptions();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(compilerOptions);
        compilerOptions.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        if (this.isSourceMappingEnabled(options)) {
            compilerOptions.setSourceMapFormat(SourceMap.Format.V3);
            compilerOptions.setSourceMapDetailLevel(SourceMap.DetailLevel.ALL);
        }
        this.setupOptions(compilerOptions, options);
        compiler.initOptions(compilerOptions);
        Result result = compiler.compile(SourceFile.fromCode((String)"externs", (String)""), SourceFile.fromReader((String)"source.js", (Reader)reader), compilerOptions);
        if (result.success) {
            writer.write(compiler.toSource());
        } else if (result.errors.length > 0) {
            throw new SmallerException("Closure Failed: " + result.errors[0].toString());
        }
    }

    private boolean isSourceMappingEnabled(Map<String, Object> options) {
        Object value = options.get("source-maps");
        return Boolean.valueOf(value != null ? value.toString() : "false");
    }

    private void setupOptions(CompilerOptions co, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            if ("version".equals(name)) continue;
            try {
                Field field = co.getClass().getField(name);
                field.set(co, map.get(name));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set compiler-option '" + name + "' to '" + map.get(name) + "'");
            }
        }
    }

    private static class LoggerOutputStream
    extends OutputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(ClosureProcessor.class);
        private final StringBuilder sb = new StringBuilder();

        private LoggerOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.sb.append((char)b);
            if ((char)b == '\n') {
                this.print();
            }
        }

        @Override
        public void flush() throws IOException {
            this.print();
            super.flush();
        }

        @Override
        public void close() throws IOException {
            this.print();
            super.close();
        }

        private void print() {
            if (this.sb.length() > 0) {
                LOGGER.info(this.sb.toString());
                this.sb.setLength(0);
            }
        }
    }
}

