/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.svgo;

import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFile;
import java.io.IOException;
import java.util.Map;

public class SvgoProcessor
implements Processor {
    private String version;
    private NodeJsExecutor node;

    public SvgoProcessor() {
        this("0.3.7");
    }

    public SvgoProcessor(String version) {
        this.version = version;
    }

    public boolean supportsType(Type type) {
        return type == Type.SVG;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        VFile file;
        String outfile;
        if (this.node == null) {
            try {
                this.node = new NodeJsExecutor();
                this.node.setModule(this.getClass(), "svgo-" + this.version, null);
            }
            catch (IOException e) {
                this.node = null;
                throw new SmallerException("Failed to setup node for svgo", (Throwable)e);
            }
        }
        if ((outfile = this.node.run(vfs, resource != null ? resource.getPath() : null, options)) != null && !(file = vfs.find('/' + outfile)).exists()) {
            throw new SmallerException("SvgoProcessor result does not exists");
        }
        return resource == null || outfile == null ? resource : resource.getResolver().resolve('/' + outfile);
    }

    public void dispose() {
        if (this.node != null) {
            this.node.dispose();
            this.node = null;
        }
    }
}

