/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.merge;

import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.resource.MergingProcessor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceGroup;
import de.matrixweb.smaller.resource.SourceMerger;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFSUtils;
import de.matrixweb.vfs.VFile;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class MergeProcessor
implements MergingProcessor {
    public boolean supportsType(Type type) {
        return true;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        if (this.getVersion(options).isAtLeast(Version._1_0_0)) {
            if (!(resource instanceof ResourceGroup) && resource != null && FilenameUtils.isExtension((String)resource.getPath(), (String)"json")) {
                return this.executeSimpleMerge(vfs, resource, options);
            }
            return this.executeComplexMerge(vfs, resource, options);
        }
        VFile snapshot = vfs.stack();
        try {
            VFile file = vfs.find(resource.getPath());
            VFSUtils.write((VFile)file, (CharSequence)resource.getContents());
            return resource.getResolver().resolve(file.getPath());
        }
        catch (IOException e) {
            vfs.rollback(snapshot);
            throw e;
        }
    }

    private Version getVersion(Map<String, Object> options) {
        Object value = options.get("version");
        return value == null ? Version.UNDEFINED : Version.getVersion((String)value.toString());
    }

    private Resource executeSimpleMerge(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        return resource.getResolver().resolve(new SourceMerger("once".equals(options.get("source"))).getMergedJsonFile(vfs, resource.getResolver(), resource.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource executeComplexMerge(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        Object typeOption = options.get("type");
        if (!(resource instanceof ResourceGroup) || typeOption != null && resource.getType() != Type.valueOf((String)typeOption.toString())) {
            return resource;
        }
        ResourceGroup group = (ResourceGroup)resource;
        Resource input = (Resource)group.getResources().get(0);
        VFile snapshot = vfs.stack();
        try {
            VFile target = vfs.find(input.getPath());
            Writer writer = VFSUtils.createWriter((VFile)target);
            try {
                writer.write(group.getMerger().merge(group.getResources()));
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
            return input.getResolver().resolve(target.getPath());
        }
        catch (IOException e) {
            vfs.rollback(snapshot);
            throw e;
        }
    }

    public void dispose() {
    }
}

