/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.nodejs;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.nodejs.NodeJsException;
import de.matrixweb.vfs.VFS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJsExecutor.class);
    private final String version = "0.10.24";
    private final ObjectMapper om = new ObjectMapper();
    private File workingDir;

    public void setModule(Class<?> clazz, String path) throws IOException, NodeJsException {
        this.setModule(clazz, path, null);
    }

    public void setModule(Class<?> clazz, String path, String script) throws IOException, NodeJsException {
        if (this.workingDir != null) {
            throw new NodeJsException("Module already set");
        }
        try {
            this.setupBinary();
        }
        catch (NodeJsException e) {
            if (this.workingDir != null) {
                this.cleanupBinary();
            }
            throw e;
        }
        Enumeration<URL> urls = clazz.getClassLoader().getResources(path);
        while (urls.hasMoreElements()) {
            this.copyModuleToWorkingDirectory(urls.nextElement(), clazz);
        }
        if (script != null) {
            this.copyScriptToWorkingDirectory(clazz.getClassLoader().getResource(script), clazz);
        }
    }

    private final void setupBinary() throws NodeJsException {
        try {
            this.workingDir = File.createTempFile("nodejs-v" + this.version, ".dir");
            this.workingDir.delete();
            this.workingDir.mkdirs();
            this.extractBinary(this.workingDir);
        }
        catch (IOException e) {
            throw new NodeJsException("Unable to setup the node folder", e);
        }
    }

    private final void cleanupBinary() {
        if (this.workingDir != null) {
            LOGGER.info("Shutdown nodejs (removing {})", (Object)this.workingDir);
            try {
                FileUtils.deleteDirectory((File)this.workingDir);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete node.js process directory", (Throwable)e);
            }
        }
    }

    private final void extractBinary(File target) throws IOException {
        File node = new File(target, this.getPlatformExecutable());
        this.copyFile("/v" + this.version + "/" + this.getPlatformPath() + "/" + this.getPlatformExecutable(), node);
        node.setExecutable(true, true);
        this.copyFile("/v" + this.version + "/ipc.js", new File(target, "ipc.js"));
    }

    private final String getPlatformPath() {
        StringBuilder sb = new StringBuilder();
        if (SystemUtils.IS_OS_WINDOWS) {
            sb.append("win");
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            sb.append("macos");
        } else if (SystemUtils.IS_OS_LINUX) {
            sb.append("linux");
        }
        if (SystemUtils.OS_ARCH.contains("64")) {
            sb.append("-x86_64");
        } else {
            sb.append("-x86");
        }
        return sb.toString();
    }

    private final String getPlatformExecutable() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "node.exe";
        }
        return "node";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyFile(String inputFile, File outputFile) throws IOException {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(inputFile);
            if (in == null) {
                throw new FileNotFoundException(inputFile);
            }
            FileUtils.copyInputStreamToFile((InputStream)in, (File)outputFile);
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    void copyScriptToWorkingDirectory(URL url, Class<?> clazz) throws IOException, NodeJsException {
        this.copyModuleToWorkingDirectory(url, clazz);
        new File(this.workingDir, new File(url.getPath()).getName()).renameTo(new File(this.workingDir, "index.js"));
    }

    void copyModuleToWorkingDirectory(URL url, Class<?> clazz) throws IOException, NodeJsException {
        block5: {
            try {
                if ("file".equals(url.getProtocol())) {
                    this.copyModuleFromFolder(url);
                    break block5;
                }
                if ("jar".equals(url.getProtocol())) {
                    this.copyModuleFromJar(url);
                    break block5;
                }
                if ("bundle".equals(url.getProtocol())) {
                    this.copyModuleFromBundle(url, clazz);
                    break block5;
                }
                throw new NodeJsException("Unsupported url schema: " + url);
            }
            catch (URISyntaxException e) {
                throw new IOException("Invalid uri syntax", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyModuleFromJar(URL url) throws IOException {
        String str = url.toString();
        String path = str.substring(str.indexOf(33) + 2);
        str = str.substring("jar:file:".length(), str.indexOf(33));
        JarFile jar = new JarFile(str);
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().startsWith(path) || entry.isDirectory()) continue;
                String name = entry.getName().substring(path.length());
                if (name.length() == 0) {
                    name = entry.getName();
                }
                File target = new File(this.workingDir, name);
                target.getParentFile().mkdirs();
                InputStream in = jar.getInputStream(entry);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)target);
            }
        }
        finally {
            jar.close();
        }
    }

    private void copyModuleFromFolder(URL url) throws URISyntaxException, IOException {
        File file = new File(url.toURI());
        if (file.isDirectory()) {
            FileUtils.copyDirectory((File)file, (File)this.workingDir);
        } else {
            FileUtils.copyFileToDirectory((File)file, (File)this.workingDir);
        }
    }

    private void copyModuleFromBundle(URL url, Class<?> clazz) throws URISyntaxException, IOException {
        LOGGER.info("Searching calling bundle for {}", (Object)url.getPath());
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        Enumeration urls = bundle.findEntries(url.getPath(), null, true);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL resourceUrl = (URL)urls.nextElement();
                File target = new File(this.workingDir, resourceUrl.getPath().substring(url.getPath().length()));
                target.getParentFile().mkdirs();
                if (resourceUrl.getPath().endsWith("/")) {
                    target.mkdir();
                    continue;
                }
                this.copyUrlFile(resourceUrl, target);
            }
        } else {
            this.copyUrlFile(bundle.getEntry(url.getPath()), new File(this.workingDir, url.getPath()));
        }
        LOGGER.info("Done searching bundle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyUrlFile(URL url, File target) throws IOException {
        InputStream in = url.openStream();
        try {
            FileOutputStream out = new FileOutputStream(target);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(VFS vfs, String infile, Map<String, Object> options) throws IOException {
        if (this.workingDir == null) {
            throw new NodeJsException("Module not set");
        }
        File temp = File.createTempFile("node-resource", ".dir");
        try {
            temp.delete();
            if (!temp.mkdirs()) {
                throw new NodeJsException("Failed to create temp folder " + temp);
            }
            File infolder = new File(temp, "input");
            if (!infolder.mkdirs()) {
                throw new NodeJsException("Failed to create temp folder " + infolder);
            }
            File outfolder = new File(temp, "output");
            if (!outfolder.mkdirs()) {
                throw new NodeJsException("Failed to create temp folder " + outfolder);
            }
            vfs.exportFS(infolder);
            String resultPath = this.callNode(infile, infolder, outfolder, options);
            vfs.stack();
            vfs.importFS(outfolder);
            String string = resultPath;
            return string;
        }
        finally {
            FileUtils.deleteDirectory((File)temp);
        }
    }

    private String callNode(String infile, File infolder, File outfolder, Map<String, Object> options) throws IOException {
        String resultPath = null;
        HashMap<String, Object> command = new HashMap<String, Object>();
        command.put("cwd", this.workingDir.getAbsolutePath());
        command.put("indir", infolder.getAbsolutePath());
        if (infile != null) {
            command.put("file", infile.startsWith("/") ? infile.substring(1) : infile);
        }
        command.put("outdir", outfolder.getAbsolutePath());
        command.put("options", options);
        String commandArg = this.om.writeValueAsString(command);
        if (SystemUtils.IS_OS_WINDOWS) {
            commandArg = '\"' + commandArg.replaceAll("\"", "\\\\\"") + '\"';
        }
        LOGGER.info("Execute node with json arg: {}", (Object)commandArg);
        ProcessBuilder builder = new ProcessBuilder(new File(this.workingDir, this.getPlatformExecutable()).getAbsolutePath(), "ipc.js", commandArg).directory(this.workingDir);
        builder.environment().put("NODE_PATH", ".");
        try {
            resultPath = this.handleResponse(new ProcessExector(builder).getResult());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new NodeJsException("node.js process interrupted", e);
        }
        return resultPath;
    }

    private String handleResponse(String response) throws IOException {
        String resultPath = null;
        try {
            Map map;
            LOGGER.info("node.js output:\n" + response.replaceAll("(?m)^[^/][^/].*?$", "").replaceAll("(?m)^//", "").replaceAll("\n+", "\n"));
            String trimmedOutput = response.replaceAll("(?m)^//.*?$", "").trim();
            Map map2 = map = trimmedOutput.length() == 0 ? Collections.emptyMap() : (Map)this.om.readValue(trimmedOutput, Map.class);
            if (map.containsKey("output")) {
                StringBuilder sb = new StringBuilder();
                for (Map entry : (List)map.get("output")) {
                    if ("INFO".equals(entry.get("level"))) {
                        sb.append("INFO  ");
                    } else if ("ERROR".equals(entry.get("level"))) {
                        sb.append("ERROR ");
                    }
                    sb.append(entry.get("message").toString()).append('\n');
                }
                LOGGER.info("node.js output:\n" + sb.toString().replaceAll("\\\\'", "###").replaceAll("'", "").replaceAll("###", "'"));
            }
            if (map.containsKey("error")) {
                LOGGER.error(map.get("error").toString());
                throw new NodeJsException(map.get("error").toString());
            }
            if (map.containsKey("result")) {
                resultPath = map.get("result").toString();
            }
        }
        catch (JsonParseException e) {
            LOGGER.error(response.replaceAll("(?m)^//.*?$", "").replaceAll("\n+", "\n"));
            throw new NodeJsException(response, e);
        }
        return resultPath;
    }

    private String waitForResponse(Process process) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(IOUtils.toString((InputStream)process.getInputStream())).append('\n').append(IOUtils.toString((InputStream)process.getErrorStream()));
        return sb.toString();
    }

    public void dispose() {
        this.cleanupBinary();
    }

    private class ProcessExector
    extends Thread {
        private CountDownLatch latch = new CountDownLatch(1);
        private ProcessBuilder builder;
        private Process process;
        private String result;
        private Exception exception;

        public ProcessExector(ProcessBuilder builder) {
            this.builder = builder;
            this.start();
        }

        @Override
        public void run() {
            try {
                this.process = this.builder.start();
                this.process.waitFor();
                this.result = NodeJsExecutor.this.waitForResponse(this.process);
                this.process = null;
            }
            catch (Exception e) {
                this.exception = e;
            }
            this.latch.countDown();
        }

        public String getResult() throws InterruptedException {
            this.latch.await(3L, TimeUnit.MINUTES);
            if (this.process != null) {
                this.process.destroy();
            }
            if (this.exception != null) {
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                throw new RuntimeException("Failed to execute node process", this.exception);
            }
            return this.result;
        }
    }
}

