/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.http;

import de.matrixweb.smaller.osgi.http.Servlet;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.resource.ProcessorFactory;
import de.matrixweb.smaller.resource.impl.OsgiServiceProcessorFactory;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private ProcessorFactory processorFactory;
    private Pipeline pipeline;
    private ServiceTracker<HttpService, HttpService> tracker;
    private final Set<HttpService> services = new HashSet<HttpService>();

    public void start(BundleContext context) throws ServletException {
        this.processorFactory = new OsgiServiceProcessorFactory(context);
        this.pipeline = new Pipeline(this.processorFactory);
        this.tracker = new ServiceTracker<HttpService, HttpService>(context, HttpService.class.getName(), null){

            public HttpService addingService(ServiceReference<HttpService> reference) {
                return Activator.this.registerServlet((HttpService)super.addingService(reference));
            }

            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                service.unregister("/");
                Activator.this.services.remove(service);
                super.removedService(reference, (Object)service);
            }
        };
        this.tracker.open();
        HttpService service = (HttpService)this.tracker.getService();
        this.registerServlet(service);
    }

    private HttpService registerServlet(HttpService service) {
        if (service != null && !this.services.contains(service)) {
            try {
                service.registerServlet("/", (javax.servlet.Servlet)new Servlet(this.pipeline), null, null);
                this.services.add(service);
            }
            catch (ServletException e) {
                LOGGER.error("Failed to create SmallerServlet", (Throwable)e);
            }
            catch (NamespaceException e) {
                LOGGER.error("Failed to register SmallerServlet on URL '/'", (Throwable)e);
            }
        }
        return service;
    }

    public void stop(BundleContext context) {
        for (HttpService service : this.services) {
            service.unregister("/");
        }
        this.services.clear();
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        if (this.processorFactory != null) {
            this.processorFactory.dispose();
            this.processorFactory = null;
        }
    }
}

