/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.cssembed;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.ProcessorUtil;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import net.nczonline.web.cssembed.CSSURLEmbedder;
import net.nczonline.web.cssembed.Embedder;
import net.nczonline.web.datauri.DataURIGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssembedProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssembedProcessor.class);

    public CssembedProcessor() {
        this.patchCssEmbedd();
    }

    public boolean supportsType(Type type) {
        return type == Type.CSS;
    }

    public Resource execute(VFS vfs, final Resource resource, final Map<String, Object> options) throws IOException {
        try {
            return ProcessorUtil.process((VFS)vfs, (Resource)resource, (String)"css", (ProcessorUtil.ProcessorCallback)new ProcessorUtil.ProcessorCallback(){

                public void call(Reader reader, Writer writer) throws IOException {
                    String root = resource.getPath();
                    int idx = root.lastIndexOf(47);
                    root = root.substring(0, idx + 1);
                    int processorOptions = 5;
                    int maxUriLength = CssembedProcessor.this.getMaxUriLength(options);
                    int maxImageSize = CssembedProcessor.this.getMaxImageSize(options);
                    new Embedder(resource, new StringReader(resource.getContents()), 5, true, maxUriLength, maxImageSize).embedImages(writer, root);
                }
            });
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Missing resource - skipping cssembed", (Throwable)e);
            return resource;
        }
    }

    private int getMaxUriLength(Map<String, Object> options) {
        Object value = options.get("max-uri-length");
        return value == null ? 32768 : Integer.parseInt(value.toString());
    }

    private int getMaxImageSize(Map<String, Object> options) {
        Object value = options.get("max-image-size");
        return value == null ? 0 : Integer.parseInt(value.toString());
    }

    public void dispose() {
    }

    private void patchCssEmbedd() {
        try {
            Field imageTypes = CSSURLEmbedder.class.getDeclaredField("imageTypes");
            imageTypes.setAccessible(true);
            ((Set)imageTypes.get(null)).add("svg");
            Field binaryTypes = DataURIGenerator.class.getDeclaredField("binaryTypes");
            binaryTypes.setAccessible(true);
            ((Map)binaryTypes.get(null)).put("svg", "image/svg+xml");
        }
        catch (NoSuchFieldException e) {
            throw new SmallerException("Failed to patch cssembed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SmallerException("Failed to patch cssembed", (Throwable)e);
        }
    }
}

