/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.jshint;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.nodejs.NodeJsExecutor;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import de.matrixweb.smaller.javascript.JavaScriptExecutorFast;
import de.matrixweb.smaller.jshint.JsHintException;
import de.matrixweb.smaller.resource.MultiResourceProcessor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceGroup;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.VFSUtils;
import de.matrixweb.vfs.VFile;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JshintProcessor
implements MultiResourceProcessor {
    private final String version;
    private JavaScriptExecutor executor;
    private NodeJsExecutor node;

    public JshintProcessor() {
        this("2.4.3");
    }

    public JshintProcessor(String version) {
        this.version = version;
    }

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(VFS vfs, Resource resource, Map<String, Object> options) throws IOException {
        String result;
        String content;
        if ("1.1.0".equals(this.version)) {
            this.setupJavascriptExecutor();
            ArrayList<String> errors = new ArrayList<String>();
            if (resource instanceof ResourceGroup) {
                for (Resource res : ((ResourceGroup)resource).getResources()) {
                    errors.addAll(this.scanResource(res, options));
                }
            } else {
                errors.addAll(this.scanResource(resource, options));
            }
            this.handleErrors(errors);
            return resource;
        }
        if (this.node == null) {
            try {
                this.node = new NodeJsExecutor();
                this.node.setModule(this.getClass(), "jshint-" + this.version, "jshint.js");
            }
            catch (IOException e) {
                this.node = null;
                throw new SmallerException("Failed to setup node for jshint", (Throwable)e);
            }
        }
        if ((content = VFSUtils.readToString((VFile)vfs.find(result = this.node.run(vfs, null, options))).trim()).length() > 0) {
            throw new JsHintException(content);
        }
        return resource;
    }

    private void setupJavascriptExecutor() {
        if (this.executor == null) {
            this.executor = new JavaScriptExecutorFast("jshint-1.1.0", 9, JshintProcessor.class);
            this.executor.addScriptFile(this.getClass().getResource("/jshint-1.1.0/jshint-1.1.0.js"));
            this.executor.addScriptFile(this.getClass().getResource("/jshint-1.1.0/jshint-call.js"));
            this.executor.addCallScript("hint(%s);");
        }
    }

    private List<String> scanResource(Resource resource, Map<String, Object> options) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        HashMap<String, Object> opts = new HashMap<String, Object>(options);
        opts.remove("version");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("source", resource.getContents());
        params.put("options", opts);
        StringWriter writer = new StringWriter();
        this.executor.run((Reader)new StringReader(new ObjectMapper().writeValueAsString(params)), (Writer)writer);
        JsHintResult result = (JsHintResult)new ObjectMapper().readValue(writer.toString(), JsHintResult.class);
        if (result.errors != null) {
            for (JsHintResult.JsHintError error : result.errors) {
                results.add(resource.getPath() + " line " + error.line + ": " + error.reason + "\n\t" + error.evidence);
            }
        }
        return results;
    }

    private void handleErrors(List<String> errors) {
        ArrayList<String> copy = new ArrayList<String>(errors);
        StringBuilder sb = new StringBuilder();
        if (copy.size() > 0) {
            sb.append((String)copy.get(0));
            copy.remove(0);
        }
        for (String error : copy) {
            sb.append('\n').append(error);
        }
        if (sb.length() > 0) {
            throw new JsHintException('\n' + sb.toString());
        }
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.dispose();
        }
        if (this.node != null) {
            this.node.dispose();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JsHintResult {
        public List<Map<String, Object>> functions;
        public Map<String, Object> options;
        public List<JsHintError> errors;

        JsHintResult() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class JsHintError {
            public String evidence;
            public String line;
            public String reason;

            JsHintError() {
            }
        }
    }
}

