/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.felix.http.base.internal.DispatcherServlet;
import org.apache.felix.http.base.internal.EventDispatcher;
import org.apache.felix.http.base.internal.HttpServiceController;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.apache.felix.http.jetty.internal.JettyLogger;
import org.apache.felix.http.jetty.internal.JettyManagedService;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class JettyService
implements Runnable {
    private static final String PID = "org.apache.felix.http";
    private final JettyConfig config;
    private final BundleContext context;
    private boolean running;
    private Thread thread;
    private ServiceRegistration configServiceReg;
    private Server server;
    private DispatcherServlet dispatcher;
    private EventDispatcher eventDispatcher;
    private final HttpServiceController controller;

    public JettyService(BundleContext context, DispatcherServlet dispatcher, EventDispatcher eventDispatcher, HttpServiceController controller) {
        this.context = context;
        this.config = new JettyConfig(this.context);
        this.dispatcher = dispatcher;
        this.eventDispatcher = eventDispatcher;
        this.controller = controller;
    }

    public void start() throws Exception {
        JettyLogger.init();
        Properties props = new Properties();
        props.put("service.pid", PID);
        this.configServiceReg = this.context.registerService("org.osgi.service.cm.ManagedService", (Object)new JettyManagedService(this), (Dictionary)props);
        this.thread = new Thread((Runnable)this, "Jetty HTTP Service");
        this.thread.start();
    }

    public void stop() throws Exception {
        if (this.configServiceReg != null) {
            this.configServiceReg.unregister();
        }
        this.running = false;
        this.thread.interrupt();
        try {
            this.thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void publishServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.config.setServiceProperties(props);
        this.controller.setProperties(props);
    }

    public void updated(Dictionary props) {
        this.config.update(props);
        if (this.running && this.thread != null) {
            this.thread.interrupt();
        }
    }

    private void startJetty() {
        try {
            this.initializeJetty();
        }
        catch (Exception e) {
            SystemLogger.error("Exception while initializing Jetty.", e);
        }
    }

    private void stopJetty() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                SystemLogger.error("Exception while stopping Jetty.", e);
            }
        }
    }

    private void initializeJetty() throws Exception {
        if (this.config.isUseHttp() || this.config.isUseHttps()) {
            StringBuffer message = new StringBuffer("Started jetty ").append(Server.getVersion()).append(" at port(s)");
            HashUserRealm realm = new HashUserRealm("OSGi HTTP Service Realm");
            this.server = new Server();
            this.server.addUserRealm(realm);
            if (this.config.isUseHttp()) {
                this.initializeHttp();
                message.append(" HTTP:").append(this.config.getHttpPort());
            }
            if (this.config.isUseHttps()) {
                this.initializeHttps();
                message.append(" HTTPS:").append(this.config.getHttpsPort());
            }
            Context context = new Context(this.server, "/", 1);
            context.addEventListener(this.eventDispatcher);
            context.getSessionHandler().addEventListener(this.eventDispatcher);
            context.addServlet(new ServletHolder(this.dispatcher), "/*");
            this.server.start();
            SystemLogger.info(message.toString());
        } else {
            SystemLogger.info("Jetty not started (HTTP and HTTPS disabled)");
        }
        this.publishServiceProperties();
    }

    private void initializeHttp() throws Exception {
        AbstractConnector connector = this.config.isUseHttpNio() ? new SelectChannelConnector() : new SocketConnector();
        connector.setPort(this.config.getHttpPort());
        connector.setMaxIdleTime(60000);
        this.server.addConnector(connector);
    }

    private void initializeHttps() throws Exception {
        AbstractConnector connector;
        if (this.config.isUseHttpsNio()) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            if (this.config.getKeystore() != null) {
                sslConnector.setKeystore(this.config.getKeystore());
            }
            if (this.config.getPassword() != null) {
                System.setProperty("jetty.ssl.password", this.config.getPassword());
                sslConnector.setPassword(this.config.getPassword());
            }
            if (this.config.getKeyPassword() != null) {
                System.setProperty("jetty.ssl.keypassword", this.config.getKeyPassword());
                sslConnector.setKeyPassword(this.config.getKeyPassword());
            }
            if (this.config.getTruststore() != null) {
                sslConnector.setTruststore(this.config.getTruststore());
            }
            if (this.config.getTrustPassword() != null) {
                sslConnector.setTrustPassword(this.config.getTrustPassword());
            }
            if ("wants".equals(this.config.getClientcert())) {
                sslConnector.setWantClientAuth(true);
            } else if ("needs".equals(this.config.getClientcert())) {
                sslConnector.setNeedClientAuth(true);
            }
            connector = sslConnector;
        } else {
            SslSocketConnector sslConnector = new SslSocketConnector();
            if (this.config.getKeystore() != null) {
                sslConnector.setKeystore(this.config.getKeystore());
            }
            if (this.config.getPassword() != null) {
                System.setProperty("jetty.ssl.password", this.config.getPassword());
                sslConnector.setPassword(this.config.getPassword());
            }
            if (this.config.getKeyPassword() != null) {
                System.setProperty("jetty.ssl.keypassword", this.config.getKeyPassword());
                sslConnector.setKeyPassword(this.config.getKeyPassword());
            }
            if (this.config.getTruststore() != null) {
                sslConnector.setTruststore(this.config.getTruststore());
            }
            if (this.config.getTrustPassword() != null) {
                sslConnector.setTrustPassword(this.config.getTrustPassword());
            }
            if ("wants".equals(this.config.getClientcert())) {
                sslConnector.setWantClientAuth(true);
            } else if ("needs".equals(this.config.getClientcert())) {
                sslConnector.setNeedClientAuth(true);
            }
            connector = sslConnector;
        }
        connector.setPort(this.config.getHttpsPort());
        connector.setMaxIdleTime(60000);
        this.server.addConnector(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        while (this.running) {
            this.startJetty();
            JettyService jettyService = this;
            synchronized (jettyService) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopJetty();
        }
    }
}

