/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.kernel.maven.impl;

import de.matrixweb.osgi.kernel.maven.impl.Dependency;
import java.util.Arrays;
import java.util.List;

public interface Filter {
    public boolean accept(Dependency var1);

    public static class AcceptAll
    implements Filter {
        @Override
        public boolean accept(Dependency dependency) {
            return true;
        }
    }

    public static class AcceptOptional
    implements Filter {
        private final Boolean optional;

        public AcceptOptional(boolean optional) {
            this.optional = optional;
        }

        @Override
        public boolean accept(Dependency dependency) {
            return this.optional.equals(dependency.isOptional());
        }
    }

    public static class AcceptScopes
    implements Filter {
        private final List<String> scopes;

        public AcceptScopes(String ... scopes) {
            this.scopes = Arrays.asList(scopes);
        }

        @Override
        public boolean accept(Dependency dependency) {
            return this.scopes.contains(dependency.getScope());
        }
    }

    public static class AcceptTypes
    implements Filter {
        private final List<String> types;

        public AcceptTypes(String ... types) {
            this.types = Arrays.asList(types);
        }

        @Override
        public boolean accept(Dependency dependency) {
            return this.types.contains(dependency.getType());
        }
    }

    public static class CompoundFilter
    implements Filter {
        private final List<Filter> filters;

        public CompoundFilter(Filter ... filters) {
            this.filters = Arrays.asList(filters);
        }

        @Override
        public boolean accept(Dependency dependency) {
            boolean accept = true;
            for (Filter filter : this.filters) {
                accept &= filter.accept(dependency);
            }
            return accept;
        }
    }

    public static class NotAcceptTypes
    implements Filter {
        private final List<String> types;

        public NotAcceptTypes(String ... types) {
            this.types = Arrays.asList(types);
        }

        @Override
        public boolean accept(Dependency dependency) {
            return !this.types.contains(dependency.getType());
        }
    }
}

