/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.kernel.maven.impl;

import de.matrixweb.osgi.kernel.maven.impl.Artifact;
import de.matrixweb.osgi.kernel.maven.impl.MavenUtils;
import de.matrixweb.osgi.kernel.maven.impl.Pom;
import java.util.LinkedList;
import java.util.List;

public class Dependency
extends Artifact {
    private final Pom pom;
    private String scope = "runtime";
    private boolean optional = false;
    private final List<Artifact> exclusions = new LinkedList<Artifact>();

    public Dependency(Pom pom) {
        super("jar");
        this.pom = pom;
    }

    @Override
    public String getGroupId() {
        return this.getPom().resolveProperties(super.getGroupId());
    }

    @Override
    public String getArtifactId() {
        return this.getPom().resolveProperties(super.getArtifactId());
    }

    @Override
    public String getVersion() {
        String v = super.getVersion();
        if (v == null) {
            v = this.getPom().getManagedDependencies().get(this.getGroupArtifactKey()).getVersion();
        }
        return this.getPom().resolveProperties(v);
    }

    public Pom getPom() {
        return this.pom;
    }

    public String getType() {
        return this.getPackagingOrType();
    }

    public void setType(String type) {
        this.setPackagingOrType(type);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void addExclusion(Artifact exclusion) {
        this.exclusions.add(exclusion);
    }

    public boolean excludes(Artifact artifact) {
        for (Artifact excl : this.getExclusions()) {
            if (!excl.getGroupArtifactKey().equals(artifact.getGroupArtifactKey())) continue;
            return true;
        }
        return false;
    }

    public List<Artifact> getExclusions() {
        return this.exclusions;
    }

    @Override
    public String toString() {
        return String.valueOf(MavenUtils.toURN(this)) + " [" + this.getScope() + (this.isOptional() ? Character.valueOf('*') : "") + "]";
    }
}

