/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.jshint;

import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import de.matrixweb.smaller.javascript.JavaScriptExecutorFast;
import de.matrixweb.smaller.jshint.JsHintException;
import de.matrixweb.smaller.resource.MergingProcessor;
import de.matrixweb.smaller.resource.MultiResource;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;

public class JshintProcessor
implements MergingProcessor {
    private final JavaScriptExecutor executor = new JavaScriptExecutorFast("jshint-1.1.0", 9, JshintProcessor.class);

    public JshintProcessor() {
        this.executor.addScriptFile(this.getClass().getResource("/jshint-1.1.0/jshint-1.1.0.js"));
        this.executor.addScriptFile(this.getClass().getResource("/jshint-1.1.0/jshint-call.js"));
        this.executor.addCallScript("hint(%s);");
    }

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(Resource resource, Map<String, String> options) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        if (resource instanceof MultiResource) {
            for (Resource res : ((MultiResource)resource).getResources()) {
                errors.addAll(this.scanResource(res, options));
            }
        } else {
            errors.addAll(this.scanResource(resource, options));
        }
        this.handleErrors(errors);
        return resource;
    }

    private List<String> scanResource(Resource resource, Map<String, String> options) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("source", resource.getContents());
        params.put("options", options);
        StringWriter writer = new StringWriter();
        this.executor.run((Reader)new StringReader(new ObjectMapper().writeValueAsString(params)), (Writer)writer);
        JsHintResult result = (JsHintResult)new ObjectMapper().readValue(writer.toString(), JsHintResult.class);
        if (result.errors != null) {
            for (JsHintResult.JsHintError error : result.errors) {
                results.add(String.valueOf(resource.getPath()) + " line " + error.line + ": " + error.reason + "\n\t" + error.evidence);
            }
        }
        return results;
    }

    private void handleErrors(List<String> errors) {
        ArrayList<String> copy = new ArrayList<String>(errors);
        StringBuilder sb = new StringBuilder();
        if (copy.size() > 0) {
            sb.append((String)copy.get(0));
            copy.remove(0);
        }
        for (String error : copy) {
            sb.append('\n').append(error);
        }
        if (sb.length() > 0) {
            throw new JsHintException(String.valueOf('\n') + sb.toString());
        }
    }

    public void dispose() {
        this.executor.dispose();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class JsHintResult {
        public List<Map<String, Object>> functions;
        public Map<String, Object> options;
        public List<JsHintError> errors;

        JsHintResult() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class JsHintError {
            public String evidence;
            public String line;
            public String reason;

            JsHintError() {
            }
        }
    }
}

