/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.osgi.service.http.NamespaceException;

public final class HandlerRegistry {
    private final Map<Servlet, ServletHandler> servletMap = new HashMap<Servlet, ServletHandler>();
    private final Map<Filter, FilterHandler> filterMap = new HashMap<Filter, FilterHandler>();
    private final Map<String, Servlet> aliasMap = new HashMap<String, Servlet>();
    private ServletHandler[] servlets = new ServletHandler[0];
    private FilterHandler[] filters = new FilterHandler[0];

    public ServletHandler[] getServlets() {
        return this.servlets;
    }

    public FilterHandler[] getFilters() {
        return this.filters;
    }

    public synchronized void addServlet(ServletHandler handler) throws ServletException, NamespaceException {
        if (this.servletMap.containsKey(handler.getServlet())) {
            throw new ServletException("Servlet instance already registered");
        }
        if (this.aliasMap.containsKey(handler.getAlias())) {
            throw new NamespaceException("Servlet with alias already registered");
        }
        handler.init();
        this.servletMap.put(handler.getServlet(), handler);
        this.aliasMap.put(handler.getAlias(), handler.getServlet());
        this.updateServletArray();
    }

    public synchronized void addFilter(FilterHandler handler) throws ServletException {
        if (this.filterMap.containsKey(handler.getFilter())) {
            throw new ServletException("Filter instance already registered");
        }
        handler.init();
        this.filterMap.put(handler.getFilter(), handler);
        this.updateFilterArray();
    }

    public synchronized void removeServlet(Servlet servlet, boolean destroy) {
        ServletHandler handler = this.servletMap.remove(servlet);
        if (handler != null) {
            this.updateServletArray();
            this.aliasMap.remove(handler.getAlias());
            if (destroy) {
                handler.destroy();
            }
        }
    }

    public synchronized void removeFilter(Filter filter, boolean destroy) {
        FilterHandler handler = this.filterMap.remove(filter);
        if (handler != null) {
            this.updateFilterArray();
            if (destroy) {
                handler.destroy();
            }
        }
    }

    public synchronized Servlet getServletByAlias(String alias) {
        return this.aliasMap.get(alias);
    }

    public synchronized void removeAll() {
        for (ServletHandler servletHandler : this.servletMap.values()) {
            servletHandler.destroy();
        }
        for (FilterHandler filterHandler : this.filterMap.values()) {
            filterHandler.destroy();
        }
        this.servletMap.clear();
        this.filterMap.clear();
        this.aliasMap.clear();
        this.updateServletArray();
        this.updateFilterArray();
    }

    private void updateServletArray() {
        Object[] tmp = this.servletMap.values().toArray(new ServletHandler[this.servletMap.size()]);
        Arrays.sort(tmp);
        this.servlets = tmp;
    }

    private void updateFilterArray() {
        Object[] tmp = this.filterMap.values().toArray(new FilterHandler[this.filterMap.size()]);
        Arrays.sort(tmp);
        this.filters = tmp;
    }
}

