/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.http;

import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.common.Zip;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.FileResourceResolver;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Servlet.class);
    private static final long serialVersionUID = -3500628755781284892L;
    private final Pipeline pipeline;

    public Servlet(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Handle smaller request from {} {}", (Object)request.getRemoteAddr(), (Object)request.getRequestURI());
        ServletOutputStream out = response.getOutputStream();
        if ("/".equals(request.getRequestURI())) {
            this.executePipeline(request, response, (OutputStream)out);
        } else {
            PrintStream print = new PrintStream((OutputStream)out);
            print.print("hallo welt");
            out.close();
        }
    }

    /*
     * Loose catch block
     */
    private void executePipeline(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException {
        Context context = null;
        try {
            try {
                context = this.setUpContext((InputStream)request.getInputStream());
                FileResourceResolver resolver = new FileResourceResolver(context.sourceDir.getAbsolutePath());
                Task task = context.manifest.getNext();
                while (task != null) {
                    this.writeResults(this.pipeline.execute((ResourceResolver)resolver, task), context.targetDir, task);
                    task = context.manifest.getNext();
                }
                Zip.zip((OutputStream)out, (File)context.targetDir);
                this.setResponseHeader(response, "OK", null);
            }
            catch (SmallerException e) {
                LOGGER.error("Error during smaller execution", (Throwable)e);
                this.handleSmallerException(response, e);
                if (context != null) {
                    context.inputZip.delete();
                    FileUtils.deleteDirectory((File)context.sourceDir);
                    FileUtils.deleteDirectory((File)context.targetDir);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (InvalidRequestException e) {
                block13: {
                    LOGGER.error(e.toString());
                    if (context == null) break block13;
                    context.inputZip.delete();
                    FileUtils.deleteDirectory((File)context.sourceDir);
                    FileUtils.deleteDirectory((File)context.targetDir);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (IOException e) {
                block14: {
                    LOGGER.error("Error during smaller execution", (Throwable)e);
                    this.setResponseHeader(response, "ERROR", "Exception during execution");
                    if (context == null) break block14;
                    context.inputZip.delete();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    FileUtils.deleteDirectory((File)context.sourceDir);
                    FileUtils.deleteDirectory((File)context.targetDir);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        finally {
            if (context != null) {
                context.inputZip.delete();
                FileUtils.deleteDirectory((File)context.sourceDir);
                FileUtils.deleteDirectory((File)context.targetDir);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private Context setUpContext(InputStream is) throws IOException {
        try {
            Context context = this.unzip(is);
            Manifest manifest = (Manifest)new ObjectMapper().readValue(this.getMainFile(context.sourceDir), Manifest.class);
            File output = context.sourceDir;
            if (Task.GlobalOptions.isOutOnly((Task)manifest.getTasks()[0])) {
                output = File.createTempFile("smaller-output", ".dir");
                output.delete();
                output.mkdirs();
            }
            context.targetDir = output;
            context.manifest = manifest;
            Context context2 = context;
            return context2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private Context unzip(InputStream is) throws IOException {
        Context context = this.storeZip(is);
        File base = File.createTempFile("smaller-work", ".dir");
        try {
            base.delete();
            base.mkdir();
            Zip.unzip((File)context.inputZip, (File)base);
        }
        catch (IOException e) {
            FileUtils.deleteDirectory((File)base);
            if (context.inputZip != null) {
                context.inputZip.delete();
            }
            throw e;
        }
        context.sourceDir = base;
        return context;
    }

    private Context storeZip(InputStream in) throws IOException {
        File temp = File.createTempFile("smaller-input", ".zip");
        try {
            temp.delete();
            FileOutputStream out = null;
            try {
                if (in.available() <= 0) {
                    throw new InvalidRequestException("Invalid attachment size; rejecting request");
                }
                out = new FileOutputStream(temp);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            FileUtils.deleteDirectory((File)temp);
            throw e;
        }
        Context context = new Context();
        context.inputZip = temp;
        return context;
    }

    private File getMainFile(File input) {
        File main = new File(input, "META-INF/MAIN.json");
        if (!main.exists() && !(main = new File(input, "MAIN.json")).exists()) {
            throw new SmallerException("Missing instructions file 'META-INF/MAIN.json'");
        }
        return main;
    }

    private void writeResults(Result result, File outputDir, Task task) throws IOException {
        this.writeResult(outputDir, task, result, Type.JS);
        this.writeResult(outputDir, task, result, Type.CSS);
    }

    private void writeResult(File output, Task task, Result result, Type type) throws IOException {
        String outputFile = this.getTargetFile(output, task.getOut(), type);
        if (outputFile != null) {
            FileUtils.writeStringToFile((File)new File(outputFile), (String)result.get(type).getContents());
        }
    }

    private String getTargetFile(File base, String[] out, Type type) {
        String target = null;
        String[] stringArray = out;
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String ext = FilenameUtils.getExtension((String)s);
            switch (type) {
                case JS: {
                    if (!ext.equals("js")) break;
                    target = new File(base, s).getAbsolutePath();
                    break;
                }
                case CSS: {
                    if (!ext.equals("css")) break;
                    target = new File(base, s).getAbsolutePath();
                    break;
                }
                default: {
                    throw new SmallerException("Invalid resource type " + type);
                }
            }
            ++n2;
        }
        return target;
    }

    private void handleSmallerException(HttpServletResponse response, SmallerException e) {
        StringBuilder message = new StringBuilder(e.getMessage());
        Throwable t = e.getCause();
        while (t != null) {
            message.append(": ").append(t.getMessage());
            t = t.getCause();
        }
        this.setResponseHeader(response, "ERROR", message.toString().replace("\n", "#@@#"));
    }

    private void setResponseHeader(HttpServletResponse response, String status, String message) {
        response.setHeader("X-Smaller-Status", status);
        if (message != null) {
            response.setHeader("X-Smaller-Message", message);
        }
    }

    private static class Context {
        private File inputZip;
        private File sourceDir;
        private File targetDir;
        private Manifest manifest;

        private Context() {
        }
    }

    private static class InvalidRequestException
    extends IOException {
        private static final long serialVersionUID = 4298402581130531621L;

        public InvalidRequestException(String message) {
            super(message);
        }
    }
}

