/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.cssembed;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.StringResource;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import net.nczonline.web.cssembed.CSSURLEmbedder;
import net.nczonline.web.cssembed.Embedder;
import net.nczonline.web.datauri.DataURIGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssembedProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssembedProcessor.class);

    public CssembedProcessor() {
        this.patchCssEmbedd();
    }

    public boolean supportsType(Type type) {
        return type == Type.CSS;
    }

    public Resource execute(Resource resource, Map<String, String> options) throws IOException {
        StringWriter writer = new StringWriter();
        String root = resource.getPath();
        int idx = root.lastIndexOf(47);
        root = root.substring(0, idx + 1);
        int maxUriLength = 32768;
        if (options.containsKey("max-uri-length")) {
            maxUriLength = Integer.parseInt(options.get("max-uri-length"));
        }
        int maxImageSize = 0;
        if (options.containsKey("max-image-size")) {
            maxImageSize = Integer.parseInt(options.get("max-image-size"));
        }
        try {
            new Embedder(resource, new StringReader(resource.getContents()), 5, true, maxUriLength, maxImageSize).embedImages(writer, root);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Missing resource - skipping cssembed", (Throwable)e);
            return resource;
        }
        return new StringResource(resource.getResolver(), resource.getType(), resource.getPath(), writer.toString());
    }

    public void dispose() {
    }

    private void patchCssEmbedd() {
        try {
            Field imageTypes = CSSURLEmbedder.class.getDeclaredField("imageTypes");
            imageTypes.setAccessible(true);
            ((Set)imageTypes.get(null)).add("svg");
            Field binaryTypes = DataURIGenerator.class.getDeclaredField("binaryTypes");
            binaryTypes.setAccessible(true);
            ((Map)binaryTypes.get(null)).put("svg", "image/svg+xml");
        }
        catch (NoSuchFieldException e) {
            throw new SmallerException("Failed to patch cssembed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SmallerException("Failed to patch cssembed", (Throwable)e);
        }
    }
}

