/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.context;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.context.ServletContextImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class ServletContextManager {
    private final Bundle bundle;
    private final ServletContext context;
    private final ServletContextAttributeListener attributeListener;
    private final Map<HttpContext, ExtServletContext> contextMap;
    private final boolean sharedAttributes;

    public ServletContextManager(Bundle bundle, ServletContext context, ServletContextAttributeListener attributeListener, boolean sharedAttributes) {
        this.bundle = bundle;
        this.context = context;
        this.attributeListener = attributeListener;
        this.contextMap = new HashMap<HttpContext, ExtServletContext>();
        this.sharedAttributes = sharedAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtServletContext getServletContext(HttpContext httpContext) {
        Map<HttpContext, ExtServletContext> map = this.contextMap;
        synchronized (map) {
            ExtServletContext context = this.contextMap.get(httpContext);
            if (context == null) {
                context = this.addServletContext(httpContext);
            }
            return context;
        }
    }

    private ExtServletContext addServletContext(HttpContext httpContext) {
        ServletContextImpl context = new ServletContextImpl(this.bundle, this.context, httpContext, this.attributeListener, this.sharedAttributes);
        this.contextMap.put(httpContext, context);
        return context;
    }
}

