/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.closure;

import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.StringResource;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureProcessor
implements Processor {
    private static final LoggerOutputStream LOGGER_OUTPUT_STREAM = new LoggerOutputStream();

    public boolean supportsType(Type type) {
        return type == Type.JS;
    }

    public Resource execute(Resource resource, Map<String, String> options) throws IOException {
        StringWriter writer = new StringWriter();
        this.compile(new StringReader(resource.getContents()), writer);
        return new StringResource(resource.getResolver(), resource.getType(), resource.getPath(), writer.toString());
    }

    public void dispose() {
    }

    private void compile(Reader reader, Writer writer) throws IOException {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler(new PrintStream(LOGGER_OUTPUT_STREAM));
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(compilerOptions);
        compiler.initOptions(compilerOptions);
        Result result = compiler.compile(SourceFile.fromCode((String)"externs", (String)""), SourceFile.fromReader((String)"source.js", (Reader)reader), compilerOptions);
        if (result.success) {
            writer.write(compiler.toSource());
        } else if (result.errors.length > 0) {
            throw new SmallerException("Closure Failed: " + result.errors[0].toString());
        }
    }

    private static class LoggerOutputStream
    extends OutputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(ClosureProcessor.class);
        private final StringBuilder sb = new StringBuilder();

        private LoggerOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.sb.append((char)b);
            if ((char)b == '\n') {
                this.print();
            }
        }

        @Override
        public void flush() throws IOException {
            this.print();
            super.flush();
        }

        @Override
        public void close() throws IOException {
            this.print();
            super.close();
        }

        private void print() {
            if (this.sb.length() > 0) {
                LOGGER.info(this.sb.toString());
                this.sb.setLength(0);
            }
        }
    }
}

