/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.maven.impl;

import de.matrixweb.smaller.osgi.maven.impl.Artifact;
import de.matrixweb.smaller.osgi.maven.impl.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Pom
extends Artifact {
    private Pom dependant;
    private Pom parent;
    private String packaging = "jar";
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Pom> managedDependencies = new HashMap<String, Pom>();
    private final Map<String, Pom> dependencies = new HashMap<String, Pom>();
    private final List<String> exclusions = new LinkedList<String>();

    public Pom() {
    }

    public Pom(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version);
        this.initProperties();
    }

    public Pom(Pom dependant, Pom copy) {
        super(copy);
        this.dependant = dependant;
        this.setPackaging(copy.getPackaging());
        this.exclusions.addAll(copy.exclusions);
        this.initProperties();
    }

    private void initProperties() {
        this.addProperty("project.groupId", this.getGroupId());
        this.addProperty("pom.groupId", this.getGroupId());
        this.addProperty("project.artifactId", this.getArtifactId());
        this.addProperty("pom.artifactId", this.getArtifactId());
        this.addProperty("project.version", this.getVersion());
        this.addProperty("pom.version", this.getVersion());
    }

    void updateAfterParentResolved() {
        if (this.getVersion() == null && this.dependant != null) {
            Artifact artifact = this.dependant.getManagedDependencies().get(this.getGroupArtifactKey());
            this.setTemplate(artifact);
        }
    }

    @Override
    public final String getGroupId() {
        return this.resolveProperties(super.getGroupId());
    }

    @Override
    public final String getArtifactId() {
        return this.resolveProperties(super.getArtifactId());
    }

    @Override
    public final String getVersion() {
        return this.resolveProperties(super.getVersion());
    }

    private String resolveProperties(String input) {
        int start;
        String result = input;
        if (result != null && (start = result.indexOf("${")) > -1) {
            int pos = 0;
            StringBuilder sb = new StringBuilder();
            while (start > -1) {
                int end = result.indexOf(125, start);
                String match = result.substring(start + 2, end);
                String replacement = this.getReplacement(match);
                if (replacement != null) {
                    sb.append(result.substring(pos, start)).append(replacement);
                } else {
                    sb.append(result.substring(pos, end + 1));
                }
                pos = end + 1;
                start = result.indexOf("${", pos);
            }
            String done = sb.toString();
            result = !done.equals(result) ? this.resolveProperties(sb.toString()) : done;
        }
        return result;
    }

    protected final String getReplacement(String name) {
        String replacement = this.getProperties().get(name);
        if (replacement == null && this.dependant != null) {
            replacement = this.dependant.getReplacement(name);
        }
        return replacement;
    }

    public Pom getParent() {
        return this.parent;
    }

    public void setParent(Pom parent) {
        this.parent = parent;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public final void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void addManagedDependency(Pom managedDependency) {
        this.managedDependencies.put(managedDependency.getGroupArtifactKey(), managedDependency);
    }

    public Map<String, Pom> getManagedDependencies() {
        HashMap<String, Pom> deps = new HashMap<String, Pom>();
        if (this.getParent() != null) {
            deps.putAll(this.getParent().getManagedDependencies());
        }
        deps.putAll(this.managedDependencies);
        return deps;
    }

    public Collection<Pom> getDependencies() {
        return this.dependencies.values();
    }

    private Set<String> getFilteredDependencies(boolean transitive, Filter filter) {
        HashSet<String> set = new HashSet<String>();
        if (filter.accept(this)) {
            set.add(this.getGroupArtifactKey());
        }
        set.addAll(this.internalGetFilteredDependencies(transitive, transitive ? new Filter.CompoundFilter(filter, new Filter.AcceptOptional(false)) : filter));
        return set;
    }

    private Set<String> internalGetFilteredDependencies(boolean transitive, Filter filter) {
        HashSet<String> set = new HashSet<String>();
        List<String> excl = this.getAllExclusions();
        for (Pom pom : this.getDependenciesIncludingParent()) {
            if (excl.contains(pom.getGroupArtifactKey()) || !filter.accept(pom)) continue;
            set.add(pom.getGroupArtifactKey());
            if (!transitive) continue;
            set.addAll(pom.internalGetFilteredDependencies(transitive, filter));
        }
        set.removeAll(excl);
        return set;
    }

    public Set<Pom> resolveNearestDependencies(Filter filter) {
        HashSet<Pom> set = new HashSet<Pom>();
        for (String candidate : this.getFilteredDependencies(true, filter)) {
            ConcurrentLinkedQueue<Pom> nodes = new ConcurrentLinkedQueue<Pom>();
            nodes.add(this);
            Pom result = this.findNearestDependency(nodes, candidate);
            if (result == null || !filter.accept(result)) continue;
            set.add(result);
        }
        return set;
    }

    private Pom findNearestDependency(Queue<Pom> nodes, String candidate) {
        while (!nodes.isEmpty()) {
            Pom node = nodes.remove();
            if (candidate.equals(node.getGroupArtifactKey())) {
                return node;
            }
            for (Pom dependency : node.getDependenciesIncludingParent()) {
                if (dependency == node) continue;
                nodes.add(dependency);
            }
        }
        return null;
    }

    private List<Pom> getDependenciesIncludingParent() {
        ArrayList<Pom> list = new ArrayList<Pom>();
        list.addAll(this.getDependencies());
        if (this.getParent() != null) {
            list.addAll(this.getParent().getDependencies());
        }
        return list;
    }

    public void addDependency(Pom dependency) {
        this.dependencies.put(dependency.getGroupArtifactKey(), dependency);
    }

    void clearDependencies() {
        this.dependencies.clear();
    }

    private List<String> getAllExclusions() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.exclusions);
        if (this.dependant != null) {
            list.addAll(this.dependant.getAllExclusions());
        }
        return list;
    }

    public void addExclusion(String exclusion) {
        this.exclusions.add(exclusion);
    }

    public final Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.getParent() != null) {
            props.putAll(this.getParent().getProperties());
        }
        props.putAll(this.properties);
        return props;
    }

    public final void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getGroupArtifactKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGroupId()).append(':').append(this.getArtifactId());
        if (!"jar".equals(this.getType())) {
            sb.append("::").append(this.getType());
        }
        return sb.toString();
    }

    public String toUrl(String repository) {
        return this.toUrl(repository, this.getPackaging());
    }

    public String toUrl(String repository, String type) {
        return String.valueOf(repository) + '/' + this.getGroupId().replace('.', '/') + '/' + this.getArtifactId() + '/' + this.getVersion() + '/' + this.getArtifactId() + '-' + this.getVersion() + '.' + type;
    }

    public int hashCode() {
        int result = 1;
        String urn = this.toURN();
        result = 31 * result + urn.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pom other = (Pom)obj;
        return this.toURN().equals(other.toURN());
    }

    public String dump(int level) {
        return this.dump(level, new Filter.AcceptAll());
    }

    public String dump(int level, Filter filter) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < level) {
            indent.append("  ");
            ++i;
        }
        StringBuilder sb = new StringBuilder(indent).append(this.toString());
        for (String gak : this.getFilteredDependencies(false, filter)) {
            Pom pom = this.dependencies.get(gak);
            if (pom == null) continue;
            sb.append("\n").append((CharSequence)indent).append(pom.dump(level + 1, filter));
        }
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.toURN()) + " [" + this.getScope() + (this.isOptional() != false ? Character.valueOf('*') : "") + "]";
    }
}

