/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.maven.impl;

import de.matrixweb.smaller.osgi.maven.impl.Pom;
import java.util.Arrays;
import java.util.List;

public interface Filter {
    public boolean accept(Pom var1);

    public static class AcceptAll
    implements Filter {
        @Override
        public boolean accept(Pom pom) {
            return true;
        }
    }

    public static class AcceptOptional
    implements Filter {
        private final Boolean optional;

        public AcceptOptional(boolean optional) {
            this.optional = optional;
        }

        @Override
        public boolean accept(Pom pom) {
            return this.optional.equals(pom.isOptional());
        }
    }

    public static class AcceptScopes
    implements Filter {
        private final List<String> scopes;

        public AcceptScopes(String ... scopes) {
            this.scopes = Arrays.asList(scopes);
        }

        @Override
        public boolean accept(Pom pom) {
            return this.scopes.contains(pom.getScope());
        }
    }

    public static class AcceptTypes
    implements Filter {
        private final List<String> types;

        public AcceptTypes(String ... types) {
            this.types = Arrays.asList(types);
        }

        @Override
        public boolean accept(Pom pom) {
            return this.types.contains(pom.getType());
        }
    }

    public static class CompoundFilter
    implements Filter {
        private final List<Filter> filters;

        public CompoundFilter(Filter ... filters) {
            this.filters = Arrays.asList(filters);
        }

        @Override
        public boolean accept(Pom pom) {
            boolean accept = true;
            for (Filter filter : this.filters) {
                accept &= filter.accept(pom);
            }
            return accept;
        }
    }

    public static class NotAcceptTypes
    implements Filter {
        private final List<String> types;

        public NotAcceptTypes(String ... types) {
            this.types = Arrays.asList(types);
        }

        @Override
        public boolean accept(Pom pom) {
            return !this.types.contains(pom.getType());
        }
    }
}

