/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.maven.impl;

public class Artifact {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String scope;
    private Boolean optional;
    private Artifact template;

    public Artifact() {
    }

    public Artifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    protected Artifact(Artifact copy) {
        this.groupId = copy.groupId;
        this.artifactId = copy.artifactId;
        this.version = copy.version;
        this.type = copy.type;
        this.scope = copy.scope;
        this.optional = copy.optional;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        String v = this.version;
        if (v == null && this.template != null) {
            v = this.template.getVersion();
        }
        return v;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        String t = this.type;
        if (t == null && this.template != null) {
            t = this.template.getType();
        }
        if (t == null) {
            t = "jar";
        }
        return t;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        String s = this.scope;
        if (s == null && this.template != null) {
            s = this.template.getScope();
        }
        if (s == null) {
            s = "compile";
        }
        return s;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Boolean isOptional() {
        Boolean o = this.optional;
        if (o == null && this.template != null) {
            o = this.template.isOptional();
        }
        if (o == null) {
            o = Boolean.FALSE;
        }
        return o;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public void clear() {
        this.groupId = null;
        this.artifactId = null;
        this.version = null;
        this.type = null;
        this.scope = null;
        this.optional = null;
    }

    public void setTemplate(Artifact template) {
        this.template = template;
    }

    public String toURN() {
        StringBuilder sb = new StringBuilder("mvn:").append(this.getGroupId()).append(':').append(this.getArtifactId()).append(':').append(this.getVersion());
        if (!"jar".equals(this.getType())) {
            sb.append(':').append(this.getType());
        }
        return sb.toString();
    }
}

