/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.http;

import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.common.Zip;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.FileResourceResolver;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Servlet.class);
    private static final long serialVersionUID = -3500628755781284892L;
    private final Pipeline pipeline;

    public Servlet(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    /*
     * Unable to fully structure code
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block10: {
            Servlet.LOGGER.info("Handle smaller request from {}", (Object)request.getRemoteAddr());
            out = response.getOutputStream();
            context = null;
            try {
                try {
                    context = this.setUpContext((InputStream)request.getInputStream());
                    resolver = new FileResourceResolver(Context.access$1(context).getAbsolutePath());
                    task = Context.access$3(context).getNext();
                    while (task != null) {
                        this.writeResults(this.pipeline.execute((ResourceResolver)resolver, task), Context.access$2(context), task);
                        task = Context.access$3(context).getNext();
                    }
                    response.setHeader("X-Smaller-Status", "OK");
                    Zip.zip((OutputStream)out, (File)Context.access$2(context));
                    break block10;
                }
                catch (SmallerException e) {
                    message = new StringBuilder(e.getMessage());
                    t = e.getCause();
                    ** while (t != null)
                }
lbl-1000:
                // 1 sources

                {
                    message.append(": ").append(t.getMessage());
                    t = t.getCause();
                    continue;
                }
lbl24:
                // 1 sources

                response.setHeader("X-Smaller-Status", "ERROR");
                response.setHeader("X-Smaller-Message", message.toString());
                break block10;
                catch (IOException e) {
                    block11: {
                        Servlet.LOGGER.error("Error during smaller execution", (Throwable)e);
                        if (context == null) break block11;
                        Context.access$0(context).delete();
                        FileUtils.deleteDirectory((File)Context.access$1(context));
                        FileUtils.deleteDirectory((File)Context.access$2(context));
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            finally {
                if (context != null) {
                    Context.access$0(context).delete();
                    FileUtils.deleteDirectory((File)Context.access$1(context));
                    FileUtils.deleteDirectory((File)Context.access$2(context));
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    private Context setUpContext(InputStream is) throws IOException {
        try {
            Context context = this.unzip(is);
            Manifest manifest = (Manifest)new ObjectMapper().readValue(this.getMainFile(context.sourceDir), Manifest.class);
            File output = context.sourceDir;
            if ("true".equals(manifest.getTasks()[0].getOptionsFor("output").get("out-only"))) {
                output = File.createTempFile("smaller-output", ".dir");
                output.delete();
                output.mkdirs();
            }
            context.targetDir = output;
            context.manifest = manifest;
            Context context2 = context;
            return context2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private Context unzip(InputStream is) throws IOException {
        Context context = this.storeZip(is);
        File base = File.createTempFile("smaller-work", ".dir");
        base.delete();
        base.mkdir();
        Zip.unzip((File)context.inputZip, (File)base);
        context.sourceDir = base;
        return context;
    }

    private Context storeZip(InputStream in) throws IOException {
        File temp = File.createTempFile("smaller-input", ".zip");
        temp.delete();
        FileOutputStream out = null;
        try {
            if (in.available() <= 0) {
                throw new IOException("Invalid attachment size; rejecting request");
            }
            out = new FileOutputStream(temp);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        Context context = new Context();
        context.inputZip = temp;
        return context;
    }

    private File getMainFile(File input) {
        File main = new File(input, "META-INF/MAIN.json");
        if (!main.exists() && !(main = new File(input, "MAIN.json")).exists()) {
            throw new SmallerException("Missing instructions file 'META-INF/MAIN.json'");
        }
        return main;
    }

    private void writeResults(Result result, File outputDir, Task task) throws IOException {
        this.writeResult(outputDir, task, result, Type.JS);
        this.writeResult(outputDir, task, result, Type.CSS);
    }

    private void writeResult(File output, Task task, Result result, Type type) throws IOException {
        String outputFile = this.getTargetFile(output, task.getOut(), type);
        if (outputFile != null) {
            FileUtils.writeStringToFile((File)new File(outputFile), (String)result.get(type).getContents());
        }
    }

    private String getTargetFile(File base, String[] out, Type type) {
        String target = null;
        String[] stringArray = out;
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String ext = FilenameUtils.getExtension((String)s);
            switch (type) {
                case JS: {
                    if (!ext.equals("js")) break;
                    target = new File(base, s).getAbsolutePath();
                    break;
                }
                case CSS: {
                    if (!ext.equals("css")) break;
                    target = new File(base, s).getAbsolutePath();
                    break;
                }
                default: {
                    throw new SmallerException("Invalid resource type " + type);
                }
            }
            ++n2;
        }
        return target;
    }

    private static class Context {
        private File inputZip;
        private File sourceDir;
        private File targetDir;
        private Manifest manifest;

        private Context() {
        }

        static /* synthetic */ File access$2(Context context) {
            return context.targetDir;
        }

        static /* synthetic */ Manifest access$3(Context context) {
            return context.manifest;
        }
    }
}

